package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;


/**
 * 薪资工资条配置主表
 *
 * @author hgw
 * @date 2021-10-08 14:36:57
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_salary_standard_set")
@Tag(name = "薪资工资条配置主表")
public class TSalaryStandardSet extends BaseEntity {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
     private String id;
     /**
      * 工资主表ID
      */
     @NotBlank(message = "工资主表ID不能为空")
     @Length(max = 32, message = "工资主表ID不能超过32个字符")
     @ExcelAttribute(name = "工资主表ID", isNotEmpty = true, errorInfo = "工资主表ID不能为空", maxLength = 32)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "工资主表ID")
     private String salaryId;
     /**
      * 结算部门id
      */
     @NotBlank(message = "结算部门id不能为空")
     @Length(max = 32, message = "结算部门id不能超过32个字符")
     @ExcelAttribute(name = "结算部门id", isNotEmpty = true, errorInfo = "结算部门id不能为空", maxLength = 32)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "结算部门id")
     private String deptId;

     /**
      * 是否为0不显示：0显示；1不显示
      */
     @ExcelAttribute(name = "是否为0不显示：0显示；1不显示")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否为0不显示：0显示；1不显示")
     private Integer isZero;

     /**
      * 明细
      */
     @TableField(exist = false)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "明细")
     private List<TSalaryStandardSetDetail> detailList = new ArrayList<>();
}
