package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.yifu.cloud.plus.v1.yifu.salary.entity.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工资报账主表（工资条）VO
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Data
@Schema(description = "工资详情VO")
public class TSalaryDetailVo implements Serializable {
	private static final long serialVersionUID = 1L;

	private TSalaryStandard salary = new TSalaryStandard();  //工资主表
	private List<TSalaryAccount> salaryAccountList = new ArrayList<>();  //工资报账

	//以下-导出需要：
	private Map<String, String> accountTitle = new HashMap<>();  //报账表浮动表头Map
	private List<String> titleSortList = new ArrayList<>();  //报账表浮动表头排序List
	//非扣税项附件
	private List<TSalaryAtta> attaList = new ArrayList<>();
	/**
	 * 薪资类审核记录 fxj 2021-11-15
	 */
	private List<TApprovalRecord> auditLogList = new ArrayList<>();
	/**
	 * 代发户列表 hgw 2023-1-13 14:36:34
	 */
	private List<TSalaryStandardIssueRes> resList = new ArrayList<>();

	private TSalaryAccountSumVo salarySum = new TSalaryAccountSumVo();  //工资主表合计金额

}
