/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TApprovalRecord;
import com.yifu.cloud.plus.v1.yifu.salary.service.TApprovalRecordService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 审批记录表
 *
 * @author huyc
 * @date 2022-08-08 22:54:44
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tapprovalrecord" )
@Tag(name = "审批记录表管理")
public class TApprovalRecordController {

    private final  TApprovalRecordService tApprovalRecordService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tApprovalRecord 审批记录表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TApprovalRecord>> getTApprovalRecordPage(Page<TApprovalRecord> page, TApprovalRecord tApprovalRecord) {
        return  new R<>(tApprovalRecordService.getTApprovalRecordPage(page,tApprovalRecord));
    }
    /**
     * 不分页查询
     * @param tApprovalRecord 审批记录表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<TApprovalRecord>> getTApprovalRecordNoPage(@RequestBody TApprovalRecord tApprovalRecord) {
        return R.ok(tApprovalRecordService.noPageDiy(tApprovalRecord));
    }

    /**
     * 通过id查询审批记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('salary_tapprovalrecord_get')")
    @GetMapping("/{id}" )
    public R<TApprovalRecord> getById(@PathVariable("id" ) String id) {
        return R.ok(tApprovalRecordService.getById(id));
    }

    /**
     * 新增审批记录表
     * @param tApprovalRecord 审批记录表
     * @return R
     */
    @Operation(summary = "新增审批记录表", description = "新增审批记录表：hasPermission('salary_tapprovalrecord_add')")
    @SysLog("新增审批记录表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('salary_tapprovalrecord_add')" )
    public R<Boolean> save(@RequestBody TApprovalRecord tApprovalRecord) {
        return R.ok(tApprovalRecordService.save(tApprovalRecord));
    }

    /**
     * 修改审批记录表
     * @param tApprovalRecord 审批记录表
     * @return R
     */
    @Operation(summary = "修改审批记录表", description = "修改审批记录表：hasPermission('salary_tapprovalrecord_edit')")
    @SysLog("修改审批记录表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('salary_tapprovalrecord_edit')" )
    public R<Boolean> updateById(@RequestBody TApprovalRecord tApprovalRecord) {
        return R.ok(tApprovalRecordService.updateById(tApprovalRecord));
    }

    /**
     * 通过id删除审批记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除审批记录表", description = "通过id删除审批记录表：hasPermission('salary_tapprovalrecord_del')")
    @SysLog("通过id删除审批记录表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('salary_tapprovalrecord_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tApprovalRecordService.removeById(id));
    }

}
