package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchasePerson;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonAddVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonSearchVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 含风险项目不购买申请明细表
 *
 * @author huych
 * @date 2025-01-10 11:23:21
 */
@Mapper
public interface TInsuranceUnpurchasePersonMapper extends BaseMapper<TInsuranceUnpurchasePerson> {
    /**
     * 含风险项目不购买申请明细表简单分页查询
     * @param tInsuranceUnpurchasePerson 含风险项目不购买申请明细表
     * @return
     */
    IPage<TInsuranceUnpurchasePerson> getTInsuranceUnpurchasePersonPage(Page<TInsuranceUnpurchasePerson> page
			, @Param("tInsuranceUnpurchasePerson") TInsuranceUnpurchasePersonSearchVo tInsuranceUnpurchasePerson);

	/**
	 * 含风险项目不购买申请表简单分页查询
	 * @param tInsuranceUnpurchasePerson 含风险项目不购买申请表
	 * @return
	 */
	long getTInsuranceUnpurchaseInfoExportCount(@Param("tInsuranceUnpurchasePerson") TInsuranceUnpurchasePersonSearchVo tInsuranceUnpurchasePerson);

	/**
	 * 含风险项目不购买申请表简单导出查询
	 * @param tInsuranceUnpurchasePerson 含风险项目不购买申请表
	 * @return
	 */
	List<TInsuranceUnpurchasePersonVo> getTInsuranceUnpurchaseInfoExportList(@Param("tInsuranceUnpurchasePerson") TInsuranceUnpurchasePersonSearchVo tInsuranceUnpurchasePerson);

	/**
	 * 含风险项目不购买申请表简单导出查询
	 * @param id 含风险项目不购买申请表id
	 * @return
	 */
	List<TInsuranceUnpurchasePersonAddVo> getTInsuranceUnpurchasePersonList(@Param("id") String id);

	List<TInsuranceUnpurchasePerson> getBuyList(@Param("deptNo") String deptNo, @Param("idCardList") List<String> idCardList);

	List<String> getSocialBuyList();

	void updateSocialStatusZero(@Param("idCardList") List<String> idCardList);

	void updateSocialStatusOne(@Param("idCardList") List<String> idCardList);

}
