package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 工资报账表附加-工资明细
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Mapper
public interface TSalaryAccountItemMapper extends BaseMapper<TSalaryAccountItem> {

     List<TSalaryAccountItem> getTSalaryAccountItemPage(@Param("tSalaryAccountItem") TSalaryAccountItem tSalaryAccountItem);
     /**
      * @param deptId
      * @param settleMonth
      * @param javaFiedName
      * @Description: 获取报账详情信息
      * @Author: hgw
      * @Date: 2019/9/29 18:26
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     List<TSalaryAccountItem> getAllTSalaryAccountItem(@Param("deptId") String deptId,
                                                       @Param("settleMonth") String settleMonth, @Param("javaFiedName") String javaFiedName,
                                                       @Param("finallyYear") String finallyYear, @Param("empIdcard") String empIdcard,
                                                       @Param("accountId") String accountId);

     /**
      * @param idCard       身份证
      * @param maxYearMonth 最大年月
      * @param invoiceTitle 封面抬头
      * @Description:
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     List<TSalaryAccountItem> getEmpAllSalaryAccountItem(@Param("idCard") String idCard, @Param("maxYearMonth") String maxYearMonth, @Param("invoiceTitle") String invoiceTitle);

     /**
      * @param idCardList
      * @param invoiceTitle
      * @Description: 获取所有报账，组装map，工资导入使用
      * @Author: hgw
      * @Date: 2022/1/27 17:04
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     List<TSalaryAccountItem> getAllItemVoList(@Param("idCardList") List<String> idCardList, @Param("invoiceTitle") String invoiceTitle);

	/**
	 * @param idCardList
	 * @param invoiceTitle
	 * @Description: 获取所有工资报账，组装map，计算年终奖使用
	 * @Author: hgw
	 * @Date: 2022/1/27 17:04
	 * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
	 **/
	List<TSalaryAccountItem> getSalaryItemVoList(@Param("idCardList") List<String> idCardList, @Param("invoiceTitle") String invoiceTitle);

     /**
      * @param deptId 结算主体id
      * @param javaFiedName   属性名
      * @param salaryMonth     工资月
      * @param empIdcard      身份证
      * @Description: 获取前几个月总工资
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.math.BigDecimal
      **/
     BigDecimal getAllMoney(@Param("deptId") String deptId
             , @Param("javaFiedName") String javaFiedName, @Param("salaryMonth") String salaryMonth
             , @Param("empIdcard") String empIdcard);

     /**
      * @param accountId    报账表id串
      * @param javaFiedName java字段名
      * @return
      * @Author pwang
      * @Date 2019-11-06 15:42
      **/
     BigDecimal getAllMoneyByAccountIdAndFiedName(@Param("accountId") String accountId
             , @Param("javaFiedName") String javaFiedName);

     /**
      * @param accountId    报账id
      * @param javaFiedName 属性名
      * @Description: 获取报账表相关金额
      * @Author: hgw
      * @Date: 2019/11/22 18:19
      * @return: java.math.BigDecimal
      **/
     BigDecimal getMoneyByAccountIdAndJavaFiedName(@Param("accountId") String accountId
             , @Param("javaFiedName") String javaFiedName);

     /**
      * @param deptId 结算主体id
      * @param javaFiedName   属性名
      * @param salaryMonth     工资月
      * @param empIdcard      身份证
      * @Description: 获取月份条数（前12个月平均工资，要除以工资月数，这里就是工资月数）
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.long.Integer
      **/
     Integer getAverageSalaryItemMonthCount(@Param("deptId") String deptId
             , @Param("javaFiedName") String javaFiedName, @Param("salaryMonth") String salaryMonth
             , @Param("empIdcard") String empIdcard);

     /**
      * @param deptId 结算主体id
      * @param javaFiedName   属性名
      * @param salaryMonth     工资月
      * @param empIdcard      身份证
      * @Description: 获取前几个月总工资
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.math.BigDecimal
      **/
     BigDecimal getEngineerAllMoney(@Param("deptId") String deptId
             , @Param("javaFiedName") String javaFiedName, @Param("salaryMonth") String salaryMonth
             , @Param("empIdcard") String empIdcard);

     /**
      * @param deptId 结算主体id
      * @param javaFiedName   属性名
      * @param salaryMonth     工资月
      * @param empIdcard      身份证
      * @Description: 获取月份条数（前12个月平均工资，要除以工资月数，这里就是工资月数）
      * @Author: hgw
      * @Date: 2019/10/29 16:51
      * @return: java.long.Integer
      **/
     Integer getEngineerAverageSalaryItemMonthCount(@Param("deptId") String deptId
             , @Param("javaFiedName") String javaFiedName, @Param("salaryMonth") String salaryMonth
             , @Param("empIdcard") String empIdcard);

     List<TSalaryAccountItem> getAccountItemList(@Param("tSalaryAccount") TSalaryAccount tSalaryAccount
             , @Param("createUserId") String createUserId, @Param("userDeptId") Integer userDeptId
             , @Param("unitName") String unitName, @Param("idStr") String idStr
             , @Param("settleMonthStart") String settleMonthStart, @Param("settleMonthEnd") String settleMonthEnd);

     List<Map<String,Object>> getSumByAccountId( @Param("account")List<TSalaryAccount> account);

     /**
      * @param salaryId
      * @Description: 获取工资明细
      * @Author: hgw
      * @Date: 2021/9/30 18:05
      * @return: java.util.Set<java.lang.String>
      **/
     Set<String> getItemSet(@Param("salaryId") String salaryId);

    /**
     * 工资报账表附加-工资明细简单分页查询
     * @param tSalaryAccountItem 工资报账表附加-工资明细
     * @return
     */
    IPage<TSalaryAccountItem> getTSalaryAccountItemPage(Page<TSalaryAccountItem> page, @Param("tSalaryAccountItem") TSalaryAccountItem tSalaryAccountItem);

	List<TSalaryAccountItem> getListByAccIdList(@Param("accIdList") List<String> accIdList);

}
