package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSpecialDeducationSum;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author fxj
 * @date 2022-08-06 13:00
 */
@Mapper
public interface TSpecialDeducationSumMapper extends BaseMapper<TSpecialDeducationSum> {
     /**
      * 简单分页查询
      *
      * @param tSpecialDeducationSum
      * @return
      */
     IPage<TSpecialDeducationSum> getTSpecialDeducationSumPage(Page page, @Param("tSpecialDeducationSum") TSpecialDeducationSum tSpecialDeducationSum);

     /**
      * @param tSpecialDeducationSum
      * @Description: 查找专项信息，返回list
      * @Author: hgw
      * @Date: 2019/9/30 16:18
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSpecialDeducationSum>
      **/
     List<TSpecialDeducationSum> getTSpecialDeducationSumList(@Param("tSpecialDeducationSum") TSpecialDeducationSum tSpecialDeducationSum);

     /**
      * @param yearMonth
      * @param idNumber
      * @Description: 获取当月专项信息
      * @Author: hgw
      * @Date: 2019/9/30 16:29
      * @return: com.yifu.cloud.v1.hrms.api.entity.TSpecialDeducationSum
      **/
     TSpecialDeducationSum getTSpecialDeducationSum(@Param("yearMonth") String yearMonth, @Param("idNumber") String idNumber, @Param("invoiceTitle") String invoiceTitle);

     /**
      * @param yearMonth
      * @param idCardList
      * @Description: 工资查询所需的全部list，组装Map来使用
      * @Author: hgw
      * @Date: 2022/1/26 16:45
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSpecialDeducationSum>
      **/
     List<TSpecialDeducationSum> getListByIdCardList(@Param("yearMonth") String yearMonth, @Param("idCardList") List<String> idCardList);

     int deleteByUnitAndMonth(@Param("yearMonth") String yearMonth, @Param("invoiceTitle") String invoiceTitle);


}
