/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardOriginalDetail;

import java.util.List;

/**
 * 薪资原表识别
 *
 * @author hgw
 * @date 2024-4-2 17:20:36
 */
public interface TSalaryStandardOriginalDetailService extends IService<TSalaryStandardOriginalDetail> {
	/**
	 * @Description: 分页查询
	 * @Author: hgw
	 * @Date: 2024/4/2 17:20
	 * @return:
	 **/
	IPage<TSalaryStandardOriginalDetail> getTSalaryStandardOriginalPage(Page<TSalaryStandardOriginalDetail> page, TSalaryStandardOriginalDetail tSalaryStandardOriginalDetail);

	/**
	 * @param originalId
	 * @Description: 获取详情
	 * @Author: hgw
	 * @Date: 2024/4/2 18:18
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardOriginalDetail>
	 **/
	List<TSalaryStandardOriginalDetail> getTSalaryStandardOriginalDetailByOrgId(String originalId);

	/**
	 * @param originalId
	 * @Description: 删除关系
	 * @Author: hgw
	 * @Date: 2024/4/3 15:39
	 * @return: boolean
	 **/
	int deleteByOrgId(String originalId);
}
