package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSet;

/**
 * 薪资工资条配置主表
 *
 * @author hgw
 * @date 2021-10-08 14:36:57
 */
public interface TSalaryStandardSetService extends IService<TSalaryStandardSet> {

     /**
      * 薪资工资条配置主表简单分页查询
      *
      * @param tSalaryStandardSet 薪资工资条配置主表
      * @return
      */
     IPage<TSalaryStandardSet> getTSalaryStandardSetPage(Page<TSalaryStandardSet> page, TSalaryStandardSet tSalaryStandardSet);

     /**
      * @param salaryId 工资id
      * @param deptId   结算主体id
      * @Description: 复制工资条配置，根据结算主体id
      * @Author: hgw
      * @Date: 2021/10/8 15:53
      * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
      **/
     void copyLastSetByDeptId(String salaryId, String deptId, String userId);

     /**
      * @param tSalaryStandardSet
      * @Description: 新增或修改工资条配置以及详情
      * @Author: hgw
      * @Date: 2021/10/8 15:27
      * @return: com.yifu.cloud.v1.common.core.util.R<com.yifu.cloud.v1.hrms.api.entity.TSalaryStandardSet>
      **/
     R<TSalaryStandardSet> saveOrUpdateSet(TSalaryStandardSet tSalaryStandardSet);

}
