/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsRemuneration;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsRemunerationSearchVo;

import javax.servlet.http.HttpServletResponse;

/**
 * 本期稿酬申报表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TStatisticsRemunerationService extends IService<TStatisticsRemuneration> {
    /**
     * 本期稿酬申报表简单分页查询
     * @param tStatisticsRemuneration 本期稿酬申报表
     * @return
     */
    IPage<TStatisticsRemuneration> getTStatisticsRemunerationPage(Page<TStatisticsRemuneration> page, TStatisticsRemunerationSearchVo tStatisticsRemuneration);

    void listExport(HttpServletResponse response, TStatisticsRemunerationSearchVo searchVo);

	/**
	 * 批量删除本期稿酬申报表
	 * @param declareMonth 申报月份
	 * @return
	 */
	R batchDelete(String declareMonth);

	/**	生成本期稿酬
	 * @param
	 * @return
	 **/
	R doStatisticsRemuneration();

	/**	手动刷新生成本期稿酬
	 * @param
	 * @return
	 **/
	R refreshStatisticsRemuneration(String declareMonth);

}
