/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TApprovalRecord;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TApprovalRecordMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TApprovalRecordService;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;
/**
 * 审批记录表
 *
 * @author huyc
 * @date 2022-08-08 22:54:44
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class TApprovalRecordServiceImpl extends ServiceImpl<TApprovalRecordMapper, TApprovalRecord> implements TApprovalRecordService {
    /**
     * 审批记录表简单分页查询
     * @param tApprovalRecord 审批记录表
     * @return
     */
    @Override
    public IPage<TApprovalRecord> getTApprovalRecordPage(Page<TApprovalRecord> page, TApprovalRecord tApprovalRecord){
        return baseMapper.getTApprovalRecordPage(page,tApprovalRecord);
    }

    @Override
    public List<TApprovalRecord> noPageDiy(TApprovalRecord searchVo) {
        LambdaQueryWrapper<TApprovalRecord> wrapper = buildQueryWrapper(searchVo);
        return baseMapper.selectList(wrapper);
    }

    private LambdaQueryWrapper buildQueryWrapper(TApprovalRecord entity){
        LambdaQueryWrapper<TApprovalRecord> wrapper = Wrappers.lambdaQuery();
        if (Common.isNotNull(entity.getSalaryId())){
            wrapper.eq(TApprovalRecord::getSalaryId,entity.getSalaryId());
        }
        return wrapper;
    }
}
