/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsTaxSalaryRule;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TStatisticsTaxSalaryRuleMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsTaxSalaryRuleService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * 个税申报手动刷新限制表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Log4j2
@Service
public class TStatisticsTaxSalaryRuleServiceImpl extends ServiceImpl<TStatisticsTaxSalaryRuleMapper, TStatisticsTaxSalaryRule> implements TStatisticsTaxSalaryRuleService {
	/**
	 * 查询
	 *
	 * @return
	 */
	@Override
	public TStatisticsTaxSalaryRule getTStatisticsTaxSalaryRule(String yearMonthDay) {
		return baseMapper.getTStatisticsTaxSalaryRule(yearMonthDay);
	}
}
