/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 收入明细表
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
@Data
@TableName("t_income")
@Schema(description = "收入明细表")
public class TIncome implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 客户id
	 */
	@ExcelAttribute(name = "客户id", maxLength = 32)
	@Length(max = 32, message = "客户id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户id")
	private String unitId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Length(max = 32, message = "项目id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Length(max = 30, message = "项目编码不能超过30个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 费用类型：1管理费2风险金
	 */
	@ExcelAttribute(name = "费用类型：1管理费2风险金", maxLength = 1)
	@Length(max = 1, message = "费用类型：1管理费2风险金不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用类型：1管理费2风险金")
	private String feeType;
	/**
	 * 收费方式：1按比例2金额-人数3金额-人次
	 */
	@ExcelAttribute(name = "收费方式：1按比例2金额-人数3金额-人次", maxLength = 1)
	@Length(max = 1, message = "收费方式：1按比例2金额-人数3金额-人次不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费方式：1按比例2金额-人数3金额-人次")
	private String feeMode;
	/**
	 * 收费标准
	 */
	@ExcelAttribute(name = "收费标准", maxLength = 10)
	@Length(max = 10, message = "收费标准不能超过10个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费标准")
	private String charges;
	/**
	 * 收入来源：1社保2公积金3商险4薪资
	 */
	@ExcelAttribute(name = "收入来源：1社保2公积金3商险4薪资", isNotEmpty = true, errorInfo = "收入来源：1社保2公积金3商险4薪资不能为空", maxLength = 1)
	@NotBlank(message = "收入来源：1社保2公积金3商险4薪资不能为空")
	@Length(max = 1, message = "收入来源：1社保2公积金3商险4薪资不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入来源：1社保2公积金3商险4薪资")
	private String sourceType;
	/**
	 * 金额
	 */
	@ExcelAttribute(name = "金额", isNotEmpty = true, errorInfo = "金额不能为空")
	@NotBlank(message = "金额不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("金额")
	private BigDecimal money;
	/**
	 * 生成月份
	 */
	@ExcelAttribute(name = "生成月份", maxLength = 6)
	@Length(max = 6, message = "生成月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生成月份")
	private String createMonth;
	/**
	 * 缴纳月份
	 */
	@ExcelAttribute(name = "缴纳月份", maxLength = 6)
	@Length(max = 6, message = "缴纳月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳月份")
	private String payMonth;
	/**
	 * 数据生成时间
	 */
	@ExcelAttribute(name = "数据生成时间", isNotEmpty = true, errorInfo = "数据生成时间不能为空", isDate = true)
	@NotBlank(message = "数据生成时间不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据生成时间")
	private Date createTime;
	/**
	 * 数据生成月份
	 */
	@ExcelAttribute(name = "数据生成月份", maxLength = 6)
	@Length(max = 6, message = "数据生成月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据生成月份")
	private String dataCreateMonth;

	/**
	 * 红冲：0否1是
	 */
	@ExcelAttribute(name = "红冲：0否1是", maxLength = 1)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("红冲：0否1是")
	private String redData;

	/**
	 * 推送状态：0未推送1已推送
	 */
	@ExcelAttribute(name = "推送状态：0未推送1已推送", maxLength = 1)
	@Length(max = 1, message = "推送状态：0未推送1已推送不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("推送状态：0未推送1已推送")
	private String sendStatus;

	@ExcelAttribute(name = "发送月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送月份")
	private String sendMonth;

	@ExcelAttribute(name = "发送时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送时间")
	private Date sendTime;

	@ExcelAttribute(name = "发送返回的EKPID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发送返回的EKPID")
	private String ekpId;

	/**
	 * 薪资申请编码
	 */
	@Schema(description = "薪资申请编码")
	private String applyNo;

	/**
	 * 收入信息结算状态 0 已结算 1 结算中 2 未结算 3 已冻结
	 */
	@Schema(description = "收入信息结算状态")
	private String incomeSettleFlag;

	/**
	 * 收入信息结算状态 0 已收 1 未收 2 垫付
	 */
	@Schema(description = "收入信息收款状态")
	private String incomeCollectFlag;

	/**
	 * 菜单ID 获取查询权限使用
	 */
	@ExcelIgnore
	@TableField(exist = false)
	private String mId;

	/**
	 * 权限sql
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String authSql;

	@TableField(exist = false)
	private String redisKey;

	/**
	 * 来源id
	 */
	@TableField(exist = false)
	private String sourceId;
}
