/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

/**
 * @author huyc
 * @date 2022-07-25 14:08:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("t_payment_info_import_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "")
public class TPaymentInfoImportLog extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private Integer id;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Length(max = 50, message = "姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 32)
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String idCard;
	/**
	 * 错误信息
	 */
	@ExcelAttribute(name = "错误信息", maxLength = 500)
	@Length(max = 500, message = "错误信息不能超过500个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("错误信息")
	private String errMsg;
	/**
	 * 问题行数
	 */
	@ExcelAttribute(name = "问题行数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("问题行数")
	private Integer line;
	/**
	 * 导入标识key
	 */
	@ExcelAttribute(name = "导入标识key", maxLength = 64)
	@Length(max = 64, message = "导入标识key不能超过64个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("导入标识key")
	private String randomKey;
}
