/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class FundImportHandleVo extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" )
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号",isNotEmpty = true,errorInfo = "身份证不可为空")
	@Schema(description = "身份证号" )
	@ExcelProperty("身份证号" )
	private String empIdcard;
	/**
	 * 公积金办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "公积金" ,isDataId = true,readConverterExp = "0=成功,1=失败",isNotEmpty = true,errorInfo = "公积金办理状态不可为空")
	@Schema(description = "公积金办理状态：0 成功，1失败" )
	@ExcelProperty("公积金" )
	private String handleStatus;
	/**
	 * 办理意见
	 */
	@ExcelAttribute(name = "办理意见",maxLength = 150,errorInfo = "办理意见长度不可超过150！")
	@Schema(description = "办理意见" )
	@ExcelProperty("办理意见")
	private String remark;
	/**
	 * 失败类型
	 */
	@ExcelAttribute(name = "失败类型",isDataId = true,isConvert = false,dataType = ExcelAttributeConstants.FUND_DISPATCH_HANDLE_REASON)
	@Schema(description = "失败类型" )
	@ExcelProperty("失败类型" )
	private String reasonType;

}
