package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/9/1
 * @Description
 * @Version 1.0
 */
@Data
public class IncomeExportVo implements Serializable {

	/**
	 * 员工姓名
	 */
	@NotBlank(message = "员工姓名 不能为空")
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名 不能为空", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@NotBlank(message = "身份证号 不能为空")
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号 不能为空", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@Length(max = 30, message = "项目编码 不能超过30 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;

	/**
	 * 费用类型：1管理费2风险金
	 */
	@Length(max = 1, message = "费用类型：1管理费2风险金 不能超过1 个字符")
	@ExcelAttribute(name = "费用类型", isDataId = true,readConverterExp = "1=管理费,2=风险金")
	@Schema(description = "费用类型：1管理费2风险金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用类型")
	private String feeType;
	/**
	 * 收费方式：1按比例2金额-人数3金额-人次
	 */
	@Length(max = 1, message = "收费方式：1按比例2金额-人数3金额-人次 不能超过1 个字符")
	@ExcelAttribute(name = "收费方式", isDataId = true,readConverterExp = "1=按比例,2=金额-人数,3=金额-人次")
	@Schema(description = "收费方式：1按比例2金额-人数3金额-人次")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费方式")
	private String feeMode;
	/**
	 * 收费标准
	 */
	@Length(max = 10, message = "收费标准 不能超过10 个字符")
	@ExcelAttribute(name = "收费标准", maxLength = 10)
	@Schema(description = "收费标准")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费标准")
	private String charges;
	/**
	 * 收入来源：1社保2公积金3商险4薪资
	 */
	@NotBlank(message = "收入来源：1社保2公积金3商险4薪资 不能为空")
	@Length(max = 1, message = "收入来源：1社保2公积金3商险4薪资 不能超过1 个字符")
	@ExcelAttribute(name = "收入来源", isNotEmpty = true, readConverterExp = "1=社保,2=公积金,3=商险,4=薪资")
	@Schema(description = "收入来源：1社保2公积金3商险4薪资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入来源")
	private String sourceType;
	/**
	 * 金额
	 */
	@NotBlank(message = "金额 不能为空")
	@ExcelAttribute(name = "金额", isNotEmpty = true, errorInfo = "金额 不能为空")
	@Schema(description = "金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("金额")
	private BigDecimal money;
	/**
	 * 生成月份
	 */
	@Length(max = 6, message = "生成月份 不能超过6 个字符")
	@ExcelAttribute(name = "生成月份", maxLength = 6)
	@Schema(description = "生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生成月份")
	private String createMonth;
	/**
	 * 缴纳月份
	 */
	@Length(max = 6, message = "缴纳月份 不能超过6 个字符")
	@ExcelAttribute(name = "缴纳月份", maxLength = 6)
	@Schema(description = "缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳月份")
	private String payMonth;
	/**
	 * 数据生成时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@NotBlank(message = "数据生成时间 不能为空")
	@ExcelAttribute(name = "数据生成时间", isNotEmpty = true, errorInfo = "数据生成时间 不能为空", isDate = true)
	@Schema(description = "数据生成时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据生成时间")
	private Date createTime;

	/**
	 * 推送状态：0未推送1已推送
	 */
	@Length(max = 1, message = "推送状态：0未推送1已推送 不能超过1 个字符")
	@ExcelAttribute(name = "推送状态", isDataId = true, readConverterExp = "0=未推送,1=已推送")
	@Schema(description = "推送状态：0未推送1已推送")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("推送状态")
	private String sendStatus;

}
