package com.yifu.cloud.plus.v1.yifu.social.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 个人社保公积金账单列表对象
 * @Author fxj
 * @Date 2020-08-25
 **/
@Data
public class PaymentBusinessPageVo {
    /**
     * 员工姓名
     **/
    @Schema(description  = "员工姓名", name = "empName")
    private String empName;
    /**
     * 员工ID
     **/
    @Schema(description  = "员工ID", name = "empName")
    private String empId;
    /**
     * 缴费月份
     **/
    @Schema(description  = "缴费月份", name = "month")
    private String month;
    /**
     *  结算主体ID
     **/
    private String settleDomainId;
    /**
     * 社保个人缴费
     **/
    @Schema(description  = "社保个人缴费", name = "socialPersonalSum")
    private BigDecimal socialPersonalSum;
    /**
     * 社保公司合计
     **/
    @Schema(description  = "社保公司合计", name = "socialUnitSum")
    private BigDecimal socialUnitSum;
    /**
     * 公积金个人合计
     **/
    @Schema(description  = "公积金个人合计", name = "fundPersonalSum")
    private BigDecimal fundPersonalSum;
    /**
     * 公积金公司合计
     **/
    @Schema(description  = "公积金公司合计", name = "fundUnitSum")
    private BigDecimal fundUnitSum;
    /**
     * 个人合计
     **/
    @Schema(description  = "个人合计", name = "personalSum")
    private BigDecimal personalSum;
    /**
     * 单位合计
     **/
    @Schema(description  = "单位合计", name = "unitSum")
    private BigDecimal unitSum;
    /**
     * 合计
     **/
    @Schema(description  = "合计", name = "sum")
    private BigDecimal sum;

    /***************************社保明细**************************/
    /**
     * 单位社保补缴利息
     */
    @Schema(description  = "单位社保补缴利息", name = "companyAccrual")
    private BigDecimal companyAccrual;
    /**
     * 个人社保补缴利息
     */
    @Schema(description  = "个人社保补缴利息", name = "personalAccrual")
    private BigDecimal personalAccrual;
    /**
     * 单位养老基数
     */
    @Schema(description  = "养老基数", name = "unitPensionSet")
    private BigDecimal unitPensionSet;
    /**
     * 单位医疗基数
     */
    @Schema(description  = "医保基数", name = "unitMedicalSet")
    private BigDecimal unitMedicalSet;
    /**
     * 单位失业基数
     */
    @Schema(description  = "失业基数", name = "unitUnemploymentSet")
    private BigDecimal unitUnemploymentSet;
    /**
     * 单位工伤基数
     */
    @Schema(description  = "工伤基数", name = "unitInjurySet")
    private BigDecimal unitInjurySet;
    /**
     * 单位生育基数
     */
    @Schema(description  = "生育基数", name = "unitBirthSet")
    private BigDecimal unitBirthSet;
    /**
     * 个人养老基数
     */
    @Schema(description  = "个人养老基数", name = "personalPensionSet")
    private BigDecimal personalPensionSet;
    /**
     * 个人医疗基数
     */
    @Schema(description  = "个人医疗基数", name = "personalMedicalSet")
    private BigDecimal personalMedicalSet;
    /**
     * 个人失业基数
     */
    @Schema(description  = "个人失业基数", name = "personalUnemploymentSet")
    private BigDecimal personalUnemploymentSet;
    /**
     * 单位养老比例
     */
    @Schema(description  = "单位养老比例", name = "unitPensionPer")
    private BigDecimal unitPensionPer;
    /**
     * 单位医疗比例
     */
    @Schema(description  = "单位医疗比例", name = "unitMedicalPer")
    private BigDecimal unitMedicalPer;
    /**
     * 单位失业比例
     */
    @Schema(description  = "单位失业比例", name = "unitUnemploymentPer")
    private BigDecimal unitUnemploymentPer;
    /**
     * 单位工伤比例
     */
    @Schema(description  = "单位工伤比例", name = "unitInjuryPer")
    private BigDecimal unitInjuryPer;
    /**
     * 单位生育比例
     */
    @Schema(description  = "单位生育比例", name = "unitBirthPer")
    private BigDecimal unitBirthPer;
    /**
     * 个人养老比例
     */
    @Schema(description  = "个人养老比例", name = "personalPensionPer")
    private BigDecimal personalPensionPer;
    /**
     * 个人医疗比例
     */
    @Schema(description  = "个人医疗比例", name = "personalMedicalPer")
    private BigDecimal personalMedicalPer;
    /**
     * 个人失业比例
     */
    @Schema(description  = "个人失业比例", name = "personalUnemploymentPer")
    private BigDecimal personalUnemploymentPer;
    /**
     * 单位大病比例
     */
    @Schema(description  = "单位大病比例", name = "unitBigailmentPer")
    private BigDecimal unitBigailmentPer;
    /**
     * 个人大病比例
     */
    @Schema(description  = "个人大病比例", name = "personalBigailmentPer")
    private BigDecimal personalBigailmentPer;
    /**
     * 单位养老金额
     */
    @Schema(description  = "养老单位缴费", name = "unitPensionMoney")
    private BigDecimal unitPensionMoney;
    /**
     * 单位医疗金额
     */
    @Schema(description  = "医保单位缴费", name = "unitMedicalMoney")
    private BigDecimal unitMedicalMoney;
    /**
     * 单位失业金额
     */
    @Schema(description  = "失业单位缴费", name = "unitUnemploymentMoney")
    private BigDecimal unitUnemploymentMoney;
    /**
     * 单位工伤金额
     */
    @Schema(description  = "工伤缴费", name = "unitInjuryMoney")
    private BigDecimal unitInjuryMoney;
    /**
     * 单位生育金额
     */
    @Schema(description  = "生育缴费", name = "unitBirthMoney")
    private BigDecimal unitBirthMoney;
    /**
     * 单位大病金额
     */
    @Schema(description  = "单位医疗救助金", name = "unitBigmailmentMoney")
    private BigDecimal unitBigmailmentMoney;
    /**
     * 个人养老金额
     */
    @Schema(description  = "养老个人缴费", name = "personalPensionMoney")
    private BigDecimal personalPensionMoney;
    /**
     * 个人医疗金额
     */
    @Schema(description  = "医保个人缴费", name = "personalMedicalMoney")
    private BigDecimal personalMedicalMoney;
    /**
     * 个人失业金额
     */
    @Schema(description  = "失业个人缴费", name = "personalUnemploymentMoney")
    private BigDecimal personalUnemploymentMoney;
    /**
     * 个人大病金额
     */
    @Schema(description  = "个人医疗救助金", name = "personalBigmailmentMoney")
    private BigDecimal personalBigmailmentMoney;
    /************************公积金明细***************************/
    /**
     * 公积金编号
     */
    @Schema(description  = "公积金编号", name = "providentNo")
    private String providentNo;
    /**
     * 单位公积金基数
     */
    @Schema(description  = "公积金单边基数", name = "unitProvidentSet")
    private BigDecimal unitProvidentSet;
    /**
     * 单边公积金比例
     */
    @Schema(description  = "公积金单边比例", name = "providentPercent")
    private BigDecimal providentPercent;
    /**
     * 个人公积金基数
     */
    @Schema(description  = "个人公积金基数", name = "personalProidentSet")
    private BigDecimal personalProidentSet;

    /**
     * 个人退费
     */
    @Schema(description  = "个人退费", name = "personalRefund")
    private BigDecimal personalRefund;

    /**
     * 公司退费
     */
    @Schema(description  = "公司退费", name = "unitRefund")
    private BigDecimal unitRefund;

    /**
     * 兼职工伤基数
     */
    @Schema(description  = "兼职工伤基数", name = "injuryAloneSet")
    private BigDecimal injuryAloneSet;

    /**
     * 兼职工伤比例
     */
    @Schema(description  = "兼职工伤比例", name = "injuryAlonePer")
    private BigDecimal injuryAlonePer;

    /**
     * 兼职工伤金额
     */
    @Schema(description  = "兼职工伤金额", name = "injuryAloneMoney")
    private BigDecimal injuryAloneMoney;
}
