/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 派单导出Vo
 * @author hgw
 * @date 2022-7-28 10:40:34
 */
@Data
@Schema(description = "派单导出Vo")
public class TDispatchInfoExportVo {

	@ExcelAttribute(name = "派单类型", readConverterExp = "0=派增,1=派减")
	@Schema(description = "派单类型：0派增1派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单类型")
	private String type;

	@Schema(description = "创建时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;

	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	@ExcelAttribute(name = "员工身份证", maxLength = 20)
	@Schema(description = "员工身份证")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工身份证")
	private String empIdcard;

	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Schema(description = "手机号码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码" )
	private String empMobile;

	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String belongUnitName;

	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	private String empType;

	/**
	 * 社保自动化标识 0 是  1  否 2 无
	 */
	@ExcelAttribute(name = "是否自动化审核",isNotEmpty = false,readConverterExp = "0=是,1=否,2=无")
	@Schema(description = "是否自动化审核:0 是  1  否2 无" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="是否自动化审核")
	private String autoFlag;

	/**
	 * 合同类型（字典值）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="合同类型")
	@ExcelAttribute(name = "合同类型")
	private String contractType;

	/**
	 * 业务细分
	 */
	@ExcelAttribute(name = "业务细分", dataType = ExcelAttributeConstants.PERSONNEL_TYPE_SUB, needExport = true)
	@Schema(description = "业务细分（存lable）", name = "contractName")
	@ExcelProperty(value ="业务细分")
	private String contractSubName;

	/**
	 * 合同期限
	 */
	@ExcelAttribute(name = "合同期限")
	@Schema(description = "合同期限" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同期限" )
	private String contractTerm;

	/**
	 * 合同起始时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始时间" )
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同到期时间" )
	private Date contractEnd;

	/**
	 * 备案基数
	 */
	@ExcelAttribute(name = "备案基数", isFloat = true,max = "999999999.99")
	@Schema(description = "备案基数：购买社保时必填" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备案基数" )
	private BigDecimal recordBase;

	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;

	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHouseholdName;

	/**
	 * 社保起缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "社保起缴日期", isDate = true)
	@Schema(description = "社保起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保起缴日期" )
	private Date socialStartDate;

	/**
	 * 社保停缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;

	/**
	 * 公积金起缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "公积金起缴日期", isDate = true)
	@Schema(description = "公积金起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金起缴日期" )
	private Date providentStart;

	/**
	 * 公积金停缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金停缴日期" )
	private Date fundReduceDate;

	@ExcelAttribute(name = "社保审核状态", readConverterExp = "0=未提交,1=待审核,2=审核通过,3=审核不通过,4=已办结,5=待SSC审核")
	@Schema(description = "社保审核状态：1待审核2审核通过3审核不通过4已办结5待SSC审核")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保审核状态")
	private String auditStatus;
	/**
	 * 审核人姓名
	 */
	@Length(max = 32, message = "社保审核人" )
	@Schema(description = "社保审核人" )
	@ExcelAttribute(name = "社保审核人")
	@ExcelProperty("社保审核人" )
	private String auditUserName;

	/**
	 * 审核意见
	 */
	@Length(max = 255, message = "审核意见 不能超过255个字符" )
	@ExcelAttribute(name = "审核意见", maxLength = 255)
	@Schema(description = "审核意见" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核意见" )
	private String auditRemark;
	/**
	 * 社保办理人
	 */
	@Length(max = 32, message = "社保办理人 不能超过32个字符" )
	@ExcelAttribute(name = "社保办理人", maxLength = 32)
	@Schema(description = "社保办理人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理人" )
	private String handleUser;
	/**
	 * 社保办理时间
	 */
	@ExcelAttribute(name = "社保办理时间", isDate = true)
	@Schema(description = "社保办理时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理时间" )
	private Date handleTime;

	/**
	 * 审核状态（0待审核/1已审核）
	 */
	@ExcelAttribute(name = "公积金审核状态",readConverterExp = "0=未提交,1=待审核,2=审核通过,3=审核不通过,4=已办结,5=待SSC审核")
	@Schema(description = "公积金审核状态:（0待审核/1已审核）" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金审核状态" )
	private String fundAuditStatus;

	/**
	 * 审核人
	 */
	@Length(max = 32, message = "公积金审核人 不能超过32个字符" )
	@ExcelAttribute(name = "公积金审核人", maxLength = 32)
	@Schema(description = "公积金审核人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金审核人" )
	private String fundAuditUser;

	@ExcelAttribute(name = "公积金办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "公积金办理状态:0 待办理 1办理成功 2 办理失败 3 已派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理状态")
	private String fundHandleStatus;
	/**
	 * 公积金办理人
	 */
	@ExcelAttribute(name = "公积金办理人", maxLength = 32)
	@Schema(description = "公积金办理人" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理人" )
	private String fundHandleUser;
	/**
	 * 公积金办理时间
	 */
	@ExcelAttribute(name = "公积金办理时间", isDate = true)
	@Schema(description = "公积金办理时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理时间" )
	private Date fundHandleTime;

	/**
	 * 公积金缴纳基数
	 */
	@NotBlank(message = "公积金缴纳基数不能为空" )
	@ExcelAttribute(name = "公积金缴纳基数", isNotEmpty = true, errorInfo = "公积金缴纳基数不能为空" )
	@Schema(description = "公积金缴纳基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳基数" )
	private BigDecimal unitProvidengCardinal;

	/**
	 * 单位公积金缴纳比例（原：公积金缴纳比例）
	 */
	@ExcelAttribute(name = "单位公积金缴纳比例" )
	@Schema(description = "单位公积金缴纳比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳比例" )
	private BigDecimal unitProvidentPer;

	/**
	 * 个人公积金缴纳比例
	 */
	@ExcelAttribute(name = "个人公积金缴纳比例" )
	@Schema(description = "个人公积金缴纳比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳比例" )
	private BigDecimal personalProvidentPer;

	/**
	 * 养老基数
	 */
	@ExcelAttribute(name = "养老基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老基数" )
	private BigDecimal unitPensionCardinal;
	/**
	 * 医疗基数
	 */
	@ExcelAttribute(name = "医疗基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗基数" )
	private BigDecimal unitMedicalCardinal;
	/**
	 * 失业基数
	 */
	@ExcelAttribute(name = "失业基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业基数" )
	private BigDecimal unitUnemploymentCardinal;

	/**
	 * 工伤基数
	 */
	@ExcelAttribute(name = "工伤基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "工伤基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
	/**
	 * 生育基数
	 */
	@ExcelAttribute(name = "生育基数",  isFloat = true,max = "999999999.99" )
	@Schema(description = "生育基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数" )
	private BigDecimal unitBirthCardinal;

	/**
	 * 大病基数
	 */
	@ExcelAttribute(name = "大病基数" ,  isFloat = true,max = "999999999.99" )
	@Schema(description = "大病基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病基数" )
	private BigDecimal unitBigailmentCardinal;

	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100 个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String trustRemark;

	/**
	 * 离职日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "离职日期", isDate = true)
	@Schema(description = "离职日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("离职日期" )
	private Date leaveDate;

	/**
	 * 减少原因
	 */
	@Length(max = 32, message = "减少原因 不能超过32个字符" )
	@ExcelAttribute(name = "减少原因", maxLength = 32, isDataId = true,dataType = ExcelAttributeConstants.REDUCE_SOCIAL_REASON)
	@Schema(description = "减少原因" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减少原因" )
	private String reduceReason;

	@Schema(description = "创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人姓名")
	private String createName;

	@ExcelAttribute(name = "派单人所属部门", maxLength = 50)
	@Schema(description = "派单人所属部门")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单人所属部门")
	private String organName;

	/**
	 * 0未提交1待审核2审核通过3审核不通过4已办结
	 */
	@ExcelAttribute(name = "派单状态",readConverterExp = "0=未提交,1=待审核,2=审核通过,3=审核不通过,4=已办结")
	@Schema(description = "0未提交1待审核2审核通过3审核不通过4已办结" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单状态" )
	private String status;

	@ExcelAttribute(name = "申请编码", maxLength = 30)
	@Schema(description = "申请编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请编码")
	private String applyNo;

	//@ExcelAttribute(name = "社保办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=部分办理失败,4=办理中")
	@Schema(description = "社保办理状态 0 待办理 1 办理成功 2 办理失败 3 部分办理失败 4 办理中")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理状态")
	private String socialHandleStatus;

	//@ExcelAttribute(name = "养老办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "养老办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老办理状态" )
	private String pensionHandle;

	//@ExcelAttribute(name = "医疗办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗办理状态" )
	private String medicalHandle;

	//@ExcelAttribute(name = "失业办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "失业办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业办理状态" )
	private String unemployHandle;

	//@ExcelAttribute(name = "工伤办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤办理状态" )
	private String workInjuryHandle;

	//@ExcelAttribute(name = "生育办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "生育办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育办理状态" )
	private String birthHandle;

	//@ExcelAttribute(name = "大病办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "大病办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病办理状态" )
	private String bigailmentHandle;

	/**
	 * 派单审核人
	 */
	@Length(max = 32, message = "派单审核人 不能超过32个字符" )
	@Schema(description = "派单审核人" )
	@ExcelProperty("派单审核人" )
	private String auditUser;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "派单审核时间", isDate = true)
	@Schema(description = "派单审核时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单审核时间" )
	private Date auditTime;
	/**
	 * 社保办理备注
	 */
	@Length(max = 255, message = "社保办理备注 不能超过255个字符" )
	@ExcelAttribute(name = "社保办理备注", maxLength = 255)
	@Schema(description = "社保办理备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保办理备注" )
	private String socialHandleRemark;
	/**
	 * 公积金办理备注
	 */
	@Length(max = 255, message = "公积金办理备注 不能超过255个字符" )
	@ExcelAttribute(name = "公积金办理备注", maxLength = 255)
	@Schema(description = "公积金办理备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金办理备注" )
	private String fundHandleRemark;

	@ExcelAttribute(name = "学历", maxLength = 32)
	@Schema(description = "学历", name = "contractName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("学历")
	private String educationName;
	/**
	 * 学校
	 */
	@ExcelAttribute(name = "学校",isNotEmpty = false)
	@Schema(description = "学校：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学校")
	private String schoolName;


	/**
	 * 专业
	 */
	@ExcelAttribute(name = "专业",isNotEmpty = false)
	@Schema(description = "专业：派增只做记录" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="专业")
	private String major;

	/**
	 * 毕业时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "毕业时间", isDate = true)
	@Schema(description = "毕业时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("毕业时间" )
	private Date graduationTime;

	/**
	 * 首次至缴纳地时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "首次至缴纳地时间",isNotEmpty = false,isDate = true)
	@Schema(description = "首次至缴纳地时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="首次至缴纳地时间")
	private Date firstPayTime;
}
