package com.yifu.cloud.plus.v1.yifu.social.config;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CustomCellStyleStrategy extends AbstractVerticalCellStyleStrategy {

	/**
	 * 操作列
	 */
	private List<Integer> columnIndexes;

	public CustomCellStyleStrategy( List<Integer> columnIndexes ) {
		this.columnIndexes = columnIndexes;
	}


	@Override
	public void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
		super.setHeadCellStyle(cell, head, relativeRowIndex);
	}

	@Override
	protected WriteCellStyle headCellStyle(Head head) {

		// 获取样式实例
		WriteCellStyle headWriteCellStyle = new WriteCellStyle();
		// 获取字体实例
		WriteFont headWriteFont = new WriteFont();
		// 设置字体样式
		headWriteFont.setFontName("宋体");
		// 设置字体大小
		headWriteFont.setFontHeightInPoints((short)20);
		// 边框
		headWriteFont.setBold(true);
		headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
		headWriteCellStyle.setWriteFont(headWriteFont);
		headWriteCellStyle.setBorderLeft(BorderStyle.NONE);
		headWriteCellStyle.setBorderBottom(BorderStyle.NONE);
		headWriteCellStyle.setBorderRight(BorderStyle.NONE);
		headWriteCellStyle.setBorderTop(BorderStyle.NONE);
		return headWriteCellStyle;
	}
}