/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.social.entity.TIncomeDetail;
import com.yifu.cloud.plus.v1.yifu.social.service.TIncomeDetailService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TIncomeDetailReturnVo;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 收入明细-详细表
 *
 * @author hgw
 * @date 2022-9-2 15:55:09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tincomedetail")
@Tag(name = "收入明细-详细表管理")
public class TIncomeDetailController {

	private final TIncomeDetailService tIncomeDetailService;

	/**
	 * @Description: 查询list（建议传参项目id、月份，一次性获取大批量，自行组装Map来使用）
	 * @Author: hgw
	 * @Date: 2022-9-2 15:56:28
	 **/
	@Inner
	@PostMapping("/inner/getTIncomeDetailList")
	public TIncomeDetailReturnVo getTIncomeDetailList(@RequestBody TIncomeDetail detail) {
		TIncomeDetailReturnVo vo = new TIncomeDetailReturnVo();
		vo.setDetailList(tIncomeDetailService.getTIncomeDetailList(detail));
		return vo;
	}

	/**
	 * @Description: 生成收入数据
	 * @Author: huyc
	 * @Date: 2022-9-2
	 **/
	@Inner
	@PostMapping("/inner/createTIncomeDetail")
	public void createTIncomeDetail(@RequestBody TIncomeDetail detail) {
		tIncomeDetailService.save(detail);
	}

	/**
	 * 通过id删除收入明细表
	 *
	 * @param tIncomeDetail
	 * @return R
	 */
	@Inner
	@PostMapping("/deleteById")
	public void deleteById(@RequestBody TIncomeDetail tIncomeDetail) {
		tIncomeDetailService.removeById(tIncomeDetail.getId());
	}
}
