/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSendEkpError;
import com.yifu.cloud.plus.v1.yifu.social.service.TSendEkpErrorService;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 推送ekp报错的记录表
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsendekperror")
@Tag(name = "推送ekp报错的记录表")
public class TSendEkpErrorController {

	private final TSendEkpErrorService tSendEkpErrorService;

	/**
	 * @Description: 新增-推送ekp报错的记录表
	 * @Author: hgw
	 * @Date: 2022/8/31 16:34
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	@Inner
	@PostMapping("/inner/saveError")
	public Boolean saveError(@RequestBody TSendEkpError tSendEkpError) {
		return tSendEkpErrorService.saveError(tSendEkpError);
	}
}
