/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialLog;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialLogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 社保变更记录表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsociallog")
@Tag(name = "社保变更记录表管理")
public class TSocialLogController {

	private final TSocialLogService tSocialLogService;


	/**
	 * 简单分页查询
	 *
	 * @param page       分页对象
	 * @param tSocialLog 社保变更记录表
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page")
	public R<IPage<TSocialLog>> getTSocialLogPage(Page<TSocialLog> page, TSocialLog tSocialLog) {
		return new R<>(tSocialLogService.getTSocialLogPage(page, tSocialLog));
	}

	/**
	 * @Description: 通过EMP_ID查询人员档案变更日志
	 * @Author: hgw
	 * @Date: 2022/6/28 16:45
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeLog>>
	 **/
	@Operation(summary = "通过mainId、type查询社保变更日志（type类型：1社保基数配置；2公积金基数配置；后续再追加）", description = "通过mainId查询社保变更日志")
	@GetMapping("/getByEmpId")
	public R<List<TSocialLog>> getByEmpId(@RequestParam String mainId, @RequestParam Integer type) {
		return R.ok(tSocialLogService.list(Wrappers.<TSocialLog>query().eq("MAIN_ID", mainId)
				.eq("TYPE", type).orderByDesc(CommonConstants.CREATE_TIME)));
	}

}
