/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPreDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPreDispatchExportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 预派单记录
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Mapper
public interface TPreDispatchInfoMapper extends BaseMapper<TPreDispatchInfo> {
    /**
     * 预派单记录简单分页查询
     * @param tPreDispatchInfo 预派单记录
	 * @author huyc
	 * @date 2022-07-14
     * @return
     */
    IPage<TPreDispatchInfo> getTPreDispatchInfoPage(Page<TPreDispatchInfo> page, @Param("tPreDispatchInfo") TPreDispatchInfo tPreDispatchInfo);

	/*
	 * 清空预派单默认的派单合同信息
	 * @param preInfo
	 * @author huyc
	 * @date 2022-07-14
	 * */
	void clearContractInfo(List<String> idList);

	/*
	 * 修改资料是否提交状态
	 * @param tPreDispatchInfo
	 * @author huyc
	 * @date 2022-07-14
	 * */
	void modifyDataSubmitStatus(@Param("idList")List<String> idList, @Param("status")String status);

	/*
	 * 更新派单信息
	 * @param tPreDispatchInfo
	 * @author huyc
	 * @date 2022-07-14
	 * */
	int updatePreDispatchInfoById(TPreDispatchInfo tPreDispatchInfo);

	/*
	* 处理派单结果
	* @param preInfo
	 * @author huyc
	 * @date 2022-07-14
	* */
	void updatePreStatusById(TPreDispatchInfo preInfo);

	/**
	 * 获取导出的数据
	 * @param tPreDispatchInfo 预派单记录
	 * @author huyc
	 * @date 2022-07-14
	 * @return
	 */
	List<TPreDispatchExportVo> getListForExport(@Param("tPreDispatchInfo")TPreDispatchInfo tPreDispatchInfo);
}
