/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion;

import java.util.List;

/**
 * 公积金政策对应的缴费比例表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
public interface SysPayProportionService extends IService<SysPayProportion> {
	/**
	 * 公积金政策对应的缴费比例表简单分页查询
	 *
	 * @param sysPayProportion 公积金政策对应的缴费比例表
	 * @return
	 */
	IPage<SysPayProportion> getSysPayProportionPage(Page<SysPayProportion> page, SysPayProportion sysPayProportion);

	/**
	 * @param sysBaseSetId
	 * @Description: 获取比例
	 * @Author: hgw
	 * @Date: 2023/2/13 15:24
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion>
	 **/
	List<SysPayProportion> getSysPayProportionByBaseId(String sysBaseSetId);
}
