/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAuditInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAuditInfoSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
public interface TAuditInfoService extends IService<TAuditInfo> {
    /**
     * 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）简单分页查询
     * @param tAuditInfo 审核信息表（社保、公积金、预估结算单、社保核准表、公积金核准表 、基数变更 审核记录）
     * @return
     */
    IPage<TAuditInfo> getTAuditInfoPage(Page<TAuditInfo> page, TAuditInfo tAuditInfo);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TAuditInfoSearchVo searchVo);

    List<TAuditInfo> noPageDiy(TAuditInfoSearchVo searchVo);
}
