/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentError;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentErrorSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 社保士兵实缴核验错误反馈表
 *
 * @author hgw
 * @date 2024-06-06 20:55:31
 */
public interface TAutoPaymentErrorService extends IService<TAutoPaymentError> {
	/**
	 * 社保士兵实缴核验错误反馈表简单分页查询
	 *
	 * @param tAutoPaymentError 社保士兵实缴核验错误反馈表
	 * @return
	 */
	IPage<TAutoPaymentError> getTAutoPaymentErrorPage(Page<TAutoPaymentError> page, TAutoPaymentErrorSearchVo tAutoPaymentError);

	void listExport(HttpServletResponse response, TAutoPaymentErrorSearchVo searchVo);

	List<TAutoPaymentError> noPageDiy(TAutoPaymentErrorSearchVo searchVo);

	void deleteByParentId(String parentId);

	/**
	 * @param parentId
	 * @Description: 根据主表id获取条数
	 * @Author: hgw
	 * @Date: 2024/6/19 16:32
	 * @return: long
	 **/
	long getCountByParentId(String parentId);

}
