/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 社保士兵
 *
 * @author hgw
 * @date 2024-5-8 14:55:24
 */
public interface TSocialSoldierService extends IService<TSocialInfo> {


	/**
	 * @param addId
	 * @Description: 查看社保士兵反馈情况
	 * @Author: hgw
	 * @Date: 2024/5/11 14:45
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> getFiveJob(String addId);

	/**
	 * @Description: 查看社保士兵审核结果查询的反馈情况
	 * @Author: hgw
	 * @Date: 2024-5-24 17:02:34
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> getSixJobByAudit();
	/**
	 * @Description: 获取实缴3张表的数据
	 * @Author: hgw
	 * @Date: 2024-5-24 17:02:34
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> doInnerGetPaymentThree();

	/**
	 * @Description: 重新办理
	 * @Author: hgw
	 * @Date: 2024/6/6 21:36
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> getReHandle(String parentId);

	R<String> getZip(MultipartFile zipFile);

	/**
	 * @Description: 加办理记录
	 * @Author: hgw
	 * @Date: 2024/8/2 9:40
	 * @return: void
	 **/
	void doSocialTAuditInfo(TSocialInfo social, String title, String handleRemark, String remark, YifuUser user);

}
