
package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import cn.hutool.json.JSONObject;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysMenu;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class MenuTreeForVue extends TreeNode {
    private String id;
	private String icon;
	private String name;
	private String path;
	private String authority;
	private String redirect;
	private String type;
	private Integer sort;
	private String  url;
	/*private Meta meta;*/
	private JSONObject meta;
	private String component;
	private String route = "1";
	private String alwaysShow;
	private boolean hidden;

	public MenuTreeForVue() {
	}

	public MenuTreeForVue(int id, String name, int parentId) {
		this.id = String.valueOf(id);
		this.parentId = Common.isNotNullToStr(parentId);
		this.name = name;
		/*this.meta=new Meta(name,null,null);*/
		this.meta =new JSONObject();
		meta.put("title",name);
	}

	public MenuTreeForVue(int id, String name, MenuTreeForVue parent) {
		this.id = String.valueOf(id);
		this.parentId = parent.getId();
		this.name = name;
		/*this.meta=new Meta(name,null,null);*/
		this.meta =new JSONObject();
		meta.put("title",name);
	}

	public MenuTreeForVue(MenuVO menuVo) {
		this.id = Common.isNotNullToStr(menuVo.getMenuId());
		this.parentId = Common.isNotNullToStr(menuVo.getParentId());
		this.icon = menuVo.getIcon();
		this.name = menuVo.getName();
		if (null != menuVo.getPath()){
			this.path = menuVo.getPath().replace("#","");
		}
		if (CommonConstants.ONE_STRING.equals(menuVo.getType())){
			this.component = menuVo.getPermission();
		}else {
			this.component = this.path;
		}
		this.type = menuVo.getType();
		if(CommonConstants.ZERO_STRING.equals(menuVo.getType())){
			alwaysShow = "true";
			hidden = false;
		}else{
			alwaysShow = "false";
			hidden = true;
		}
		this.sort = menuVo.getSort();
		this.url = menuVo.getUrl();
		/*this.meta=new Meta(menuVo.getName(),menuVo.getIcon(),menuVo.getKeepAlive());*/
		this.meta =new JSONObject();
		meta.put("title",menuVo.getName());
		meta.put("icon",menuVo.getIcon());
		meta.put("keepAlive",menuVo.getKeepAlive());
		/*this.authority = menuVo.getPermission();*/
	}

	public MenuTreeForVue(SysMenu menuVo) {
		this.id = Common.isNotNullToStr(menuVo.getMenuId());
		this.parentId = Common.isNotNullToStr(menuVo.getParentId());
		this.icon = menuVo.getIcon();
		this.name = menuVo.getName();
		if (null != menuVo.getPath()){
			this.path = menuVo.getPath().replace("#","");
		}
		if (CommonConstants.ONE_STRING.equals(menuVo.getType())){
			this.component = menuVo.getPermission();
		}else {
			this.component = this.path;
		}
		this.type = menuVo.getType();
		if(CommonConstants.ZERO_STRING.equals(menuVo.getType())){
			alwaysShow = "true";
			hidden = false;
		}else{
			alwaysShow = "false";
			hidden = true;
		}
		this.sort = menuVo.getSortOrder();
		this.url = menuVo.getPath();
		/*this.meta=new Meta(menuVo.getName(),menuVo.getIcon(),menuVo.getKeepAlive());*/
		this.meta =new JSONObject();
		meta.put("title",menuVo.getName());
		meta.put("icon",menuVo.getIcon());
		meta.put("keepAlive",menuVo.getKeepAlive());
		/*this.authority = menuVo.getPermission();*/
	}
}
