/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icbc.api.request.ErrorHandlingProRequestV1;
import com.pig4cloud.plugin.excel.annotation.RequestExcel;
import com.pig4cloud.plugin.excel.annotation.ResponseExcel;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysRole;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUserDeptPermission;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.HcmRoleInfoVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.RoleExcelVO;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.RoleVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.UserCspVO;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysRoleMenuService;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysRoleService;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysUserDeptPermissionService;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysUserService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ClientNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author fxj
 * @Description 客户服务平台 账号 部门  项目  关系表
 * @Date 18:38 2025/2/25
 * @Param
 * @return
**/
@RestController
@RequiredArgsConstructor
@RequestMapping("/userDeprtPermission")
@Tag(name = "客户服务平台账号授权")
public class SysUserDeptPermissionController {

	private final SysUserDeptPermissionService sysUserDeptPermissionService;

	private final SysUserService sysUserService;

	/**
	 * 新增
	 * @Description 新增用户
	 * @return success、false
	 */
	@SysLog("新增用户")
	@PostMapping("/add")
	public R<Boolean> save(@Valid @RequestBody UserCspVO entity) {
		return sysUserDeptPermissionService.saveAsso(entity);
	}

	/**
	 * 修改用户
	 * @param entity 修改用户
	 * @return success/false
	 */
	@SysLog("修改用户")
	@PostMapping("/update")
	public R<Boolean> update(@Valid @RequestBody UserCspVO entity) {
		return sysUserDeptPermissionService.updateByIdAsso(entity);
	}

	/**
	 * 收回用户
	 * @param userId
	 * @return
	 */
	@SysLog("收回用户")
	@DeleteMapping("/disable")
	public R<Boolean> removeById(@RequestParam(required = true,value = "userId") String userId,
								 @RequestParam(required = true,value = "projectNo") String projectNo) {
		return sysUserDeptPermissionService.removeUserDeptPermissionById(userId,projectNo);
	}

}
