/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysAreaMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysAreaService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ServiceNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 字典项
 *
 * @author hgw
 * @date 2022-6-22 19:40:43
 */
@Service
public class SysAreaServiceImpl extends ServiceImpl<SysAreaMapper, SysArea> implements SysAreaService {

	@Override
	public R<Map<String, String>> getAreaToId() {
		Map<String, String> resultMap = this.getStringMapMap(true);
		return R.ok(resultMap);
	}

	@Override
	public R<Map<String, String>> getAreaToName() {
		Map<String, String> resultMap = this.getStringMapMap(false);
		return R.ok(resultMap);
	}

	@Override
	public List<SysArea> getAllArea() {
		return baseMapper.selectList(Wrappers.<SysArea>query().lambda());
	}

	private Map<String, String> getStringMapMap(boolean type) {
		List<SysArea> allList = baseMapper.selectList(Wrappers.<SysArea>query().lambda()
				.eq(SysArea::getStatus, CommonConstants.ZERO_INT));
		Map<String, String> resultMap = new HashMap<>();
		doAssemble(allList, resultMap, type);
		return resultMap;
	}

	/**
	 * @Description: 组装
	 * @Author: hgw
	 * @Date: 2022/6/22 18:12
	 * @return: void
	 **/
	private void doAssemble(List<SysArea> allList, Map<String, String> resultMap, boolean type) {
		if (Common.isNotNull(allList)) {
			for (SysArea item : allList) {
				if (type) {
					resultMap.put(String.valueOf(item.getId()), item.getAreaName());
				} else {
					resultMap.put(item.getAreaName(), String.valueOf(item.getId()));
				}
			}
		}
	}
	@Override
	@Cacheable(value = ServiceNameConstants.UMPS_SERVICE + "_permanent", key = "#root.targetClass+#root.methodName")
	public Map<Integer,SysArea> getSysAreaMap() {
		List<SysArea> list = this.list();
		Map<Integer,SysArea> sysAreaMap = null;
		if(Common.isNotNull(list)){
			sysAreaMap = new HashMap();
			for(SysArea area : list){
				sysAreaMap.put(area.getId(),area);
			}
		}
		return sysAreaMap;
	}

	@Override
	@Cacheable(value = ServiceNameConstants.UMPS_SERVICE + "_permanent", key = "#root.targetClass+#root.methodName")
	public List<AreaVo> getAreaTree() {
		List<AreaVo> pArea = new ArrayList<>();
		List<AreaVo> list = baseMapper.getVoArea();
		if (Common.isNotNull(list)) {
			List<AreaVo> tArea = new ArrayList<>();
			Map<Integer, AreaVo> pMap = new HashMap<>();
			Map<Integer, AreaVo> cAreaMap = new HashMap<>();
			for (AreaVo area : list) {
				if (CommonConstants.dingleDigitIntArray[0] == area.getParentId().intValue()) {
					pArea.add(area);
					pMap.put(area.getId(), area);
				}
			}
			list.removeAll(pArea);
			for (AreaVo area : list) {
				if (null != pMap.get(area.getParentId())) {
					cAreaMap.put(area.getId(), area);
				} else {
					tArea.add(area);
				}
			}
			AreaVo tempArea = null;
			List<AreaVo> tempList = null;
			//所有县级节点挂到市级节点上
			for (AreaVo area : tArea) {
				tempArea = cAreaMap.get(area.getParentId());
				tempList = tempArea.getChildren();
				if (null == tempList) {
					tempList = new ArrayList<>();
					tempList.add(area);
					tempArea.setChildren(tempList);
				} else {
					tempList.add(area);
				}
			}
			for (AreaVo area : cAreaMap.values()) {
				tempArea = pMap.get(area.getParentId());
				tempList = tempArea.getChildren();
				if (null == tempList) {
					tempList = new ArrayList<>();
					tempList.add(area);
					tempArea.setChildren(tempList);
				} else {
					tempList.add(area);
				}
			}
		}
		return pArea;
	}

}
