/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMax;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 项目表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
@Data
@TableName("t_settle_domain")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "项目表")
public class TSettleDomain extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String departNo;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String departName;

	/**
	 * 是否是新业务（0是/1否）
	 */
	@Schema(description = "是否是新业务（0是/1否）")
	private String isNew;

	/**
	 * 新业务备注
	 */
	@Schema(description = "新业务备注")
	private String newRemark;

	/**
	 * 是否删除（0否/1是）
	 */
	@Schema(description = "是否删除（0否/1是）")
	private String deleteFlag;

	/**
	 * 服务审核标识（0是通过，1是不通过，2待审核，3待提交，4经理通过，5经理不通过）默认2
	 */
	@Schema(description = "服务审核标识（0是通过，1是不通过，2待审核，3待提交，4经理通过，5经理不通过）默认2")
	private String dpAuditFlag;

	/**
	 * 原ID
	 */
	@Schema(description = "原ID")
	private String oldId;

	/**
	 * 合同主体
	 */
	@Schema(description = "合同主体")
	private String belongContract;

	/**
	 * 业务经理审核意见
	 */
	@Schema(description = "业务经理审核意见")
	private String dpAuditOpinion;

	/**
	 * 审核人id
	 */
	@Schema(description = "审核人id")
	private String dpAuditMan;

	/**
	 * 审核人名称
	 */
	@Schema(description = "审核人名称")
	private String dpAuditManName;

	/**
	 * 最后审核时间
	 */
	@Schema(description = "最后审核时间")
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
	private LocalDateTime lastAuditDate;

	/**
	 * 服务项目
	 */
	@Schema(description = "服务项目")
	private String serverItem;

	/**
	 * 收入归属
	 */
	@Schema(description = "收入归属")
	private String incomeBelong;

	/**
	 * 收入归属细分
	 */
	@Schema(description = "收入归属细分")
	private String incomeBelongSub;

	/**
	 * 所属客户
	 */
	@Schema(description = "所属客户")
	private String customerId;

	/**
	 * 创建者姓名
	 */
	@Schema(description = "创建者姓名")
	private String createUserName;

	/**
	 * 最后提交人
	 */
	@Schema(description = "最后提交人")
	private String commitUser;

	/**
	 * 最后提交人姓名
	 */
	@Schema(description = "最后提交人姓名")
	private String commitUserName;

	/**
	 * 账户余额
	 */
	@Schema(description = "账户余额")
	private BigDecimal balance;

	/**
	 * 开票余额
	 */
	@Schema(description = "开票余额")
	private BigDecimal invoiceBalance;

	/**
	 * 首次审核通过标志0审核通过1未审核通过
	 */
	@Schema(description = "首次审核通过标志0审核通过1未审核通过")
	private String firstPassFlag;

	/**
	 * 首次审核通过时间
	 */
	@Schema(description = "首次审核通过时间")
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
	private LocalDateTime firstPassTime;

	/**
	 * 省
	 */
	@Schema(description = "省")
	private Integer province;

	/**
	 * 市
	 */
	@Schema(description = "市")
	private Integer city;

	/**
	 * 县
	 */
	@Schema(description = "县")
	private Integer town;

	/**
	 * 服务状态：0正常 1停止服务 2冻结
	 */
	@Schema(description = "服务状态：0正常 1停止服务 2冻结")
	private String stopFlag;

	/**
	 * 在职人数（正式加临时）
	 */
	@Schema(description = "在职人数（正式加临时）")
	private Integer employeeNum;

	/**
	 * 停止时间
	 */
	@Schema(description = "停止时间")
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
	private LocalDateTime stopDate;

	/**
	 * stopReason
	 */
	@Schema(description = "stopReason")
	private String stopReason;

	/**
	 * stopUser
	 */
	@Schema(description = "stopUser")
	private String stopUser;

	/**
	 * stopUserName
	 */
	@Schema(description = "stopUserName")
	private String stopUserName;

	/**
	 * 0：人事；1：非人事
	 */
	@Schema(description = "0：人事；1：非人事")
	private Integer type;

	/**
	 * 业务类型分类
	 */
	@Schema(description = "业务类型分类")
	private String businessPrimaryType;

	/**
	 * 业务类型二级分类
	 */
	@Schema(description = "业务类型二级分类")
	private String businessSecondType;

	/**
	 * 业务类型三级分类
	 */
	@Schema(description = "业务类型三级分类")
	private String businessThirdType;

	/**
	 * 业务经理审核意见
	 */
	@Schema(description = "业务经理审核意见")
	private String managerAuditOpinion;

	/**
	 * 审核人id
	 */
	@Schema(description = "审核人id")
	private String managerAuditMan;

	/**
	 * 审核人名称
	 */
	@Schema(description = "审核人名称")
	private String managerAuditManName;

	/**
	 * 审核人审核的时间
	 */
	@Schema(description = "审核人审核的时间")
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
	private LocalDateTime auditTime;

	/**
	 * 经理审核时间
	 */
	@Schema(description = "经理审核时间")
	@JsonFormat(pattern = "yyyy-MM-dd  HH:mm:ss")
	private LocalDateTime managerAuditTime;

	/**
	 * 创建类型：0 合同之后 1 合同之前
	 */
	@Schema(description = "创建类型：0 合同之后 1 合同之前")
	private String createType;

	/**
	 * 关联合同：0是1否
	 */
	@Schema(description = "关联合同：0是1否")
	private String relateFlag;

	/**
	 * 异常说明
	 */
	@Schema(description = "异常说明")
	private String exceptionRemark;

	/**
	 * 是否存在垫付 0 不存在，1存在
	 */
	@Schema(description = "是否存在垫付 0 不存在，1存在")
	private String existAdvancePayment;

	/**
	 * 回款周期1-12
	 */
	@Schema(description = "回款周期1-12")
	private String backPayCycle;

	/**
	 * 社保类型0：缴费库；1：预估库
	 */
	@ExcelAttribute(name = "社保类型0：缴费库；1：预估库")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保类型0：缴费库；1：预估库")
	@Schema(description = "社保类型0：缴费库；1：预估库")
	private String socialType;
	/**
	 * 公积金类型0：缴费库；1：预估库
	 */
	@ExcelAttribute(name = "公积金类型0：缴费库；1：预估库")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金类型0：缴费库；1：预估库")
	@Schema(description = "公积金类型0：缴费库；1：预估库")
	private String fundType;
	/**
	 * 商险结算类型0 合并（预估） 1 单独（实缴）
	 */
	@ExcelAttribute(name = "商险结算类型0 合并 1 单独")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("商险结算类型0 合并 1 单独")
	@Schema(description = "商险结算类型0 合并 1 单独")
	private String insuranceSettleType;
	/**
	 * 封面抬头-薪资
	 */
	@ExcelAttribute(name = "封面抬头-薪资", maxLength = 50)
	@Length(max = 50, message = "封面抬头-薪资不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头-薪资")
	private String invoiceTitleSalary;
	/**
	 * 封面抬头-商险
	 */
	@ExcelAttribute(name = "封面抬头-商险", maxLength = 50)
	@Length(max = 50, message = "封面抬头-商险不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头-商险")
	private String invoiceTitleInsurance;
	/**
	 * 我司到款单位
	 */
	@ExcelAttribute(name = "我司到款单位", maxLength = 100)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("我司到款单位")
	private String unitOfOurCompany;
	/**
	 * 所属客户编码
	 */
	@Schema(description = "所属客户编码")
	private String customerNo;
	/**
	 * 所属客户名称
	 */
	@Schema(description = "所属客户名称")
	private String customerName;

	/**
	 * 省
	 */
	@Schema(description = "省")
	@TableField(exist = false)
	private String eProvince;

	/**
	 * 市
	 */
	@Schema(description = "市")
	@TableField(exist = false)
	private String eCity;

	/**
	 * 县
	 */
	@Schema(description = "县")
	@TableField(exist = false)
	private String eTown;

	/**
	 * 管理费风险金的结算方式：1预估2实缴
	 */
	@ExcelAttribute(name = "管理费风险金的结算方式：1预估2实缴"  , maxLength = 1 )
	@Length(max=1,message = "管理费风险金的结算方式：1预估2实缴不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("管理费风险金的结算方式：1预估2实缴")
	private String mrSettleType;
	/**
	 * 管理费是否收费（0收费/1不收费）
	 */
	@ExcelAttribute(name = "管理费是否收费（0收费/1不收费）"  , maxLength = 1 )
	@Length(max=1,message = "管理费是否收费（0收费/1不收费）不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("管理费是否收费（0收费/1不收费）")
	private String managementTag;
	/**
	 * 管理费费率/管理费金额
	 */
	@ExcelAttribute(name = "管理费费率/管理费金额"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("管理费费率/管理费金额")
	private BigDecimal managementFee;
	/**
	 * 管理费收费方式：1按比例2金额-人数3金额-人次
	 */
	@ExcelAttribute(name = "管理费收费方式：1按比例2金额-人数3金额-人次"  , maxLength = 32 )
	@Length(max=32,message = "管理费收费方式：1按比例2金额-人数3金额-人次不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("管理费收费方式：1按比例2金额-人数3金额-人次")
	private String managementType;
	/**
	 * 风险金是否收取
	 */
	@ExcelAttribute(name = "风险金是否收取"  , maxLength = 1 )
	@Length(max=1,message = "风险金是否收取不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("风险金是否收取")
	private String riskFundTag;
	/**
	 * 风险金收取费用/税率
	 */
	@ExcelAttribute(name = "风险金收取费用/税率"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("风险金收取费用/税率")
	private BigDecimal riskFundFee;
	/**
	 * 风险金收费方式：1按比例2金额-人数3金额-人次
	 */
	@ExcelAttribute(name = "风险金收费方式：1按比例2金额-人数3金额-人次"  , maxLength = 32 )
	@Length(max=32,message = "风险金收费方式：1按比例2金额-人数3金额-人次不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("风险金收费方式：1按比例2金额-人数3金额-人次")
	private String riskFundType;

	/**
	 * 管理费的收取服务项目：1社保2公积金3商险4薪酬
	 */
	@ExcelAttribute(name = "管理费的收取服务项目：1社保2公积金3商险4薪酬"  , maxLength = 4 )
	@Length(max=4,message = "管理费的收取服务项目：1社保2公积金3商险4薪酬不能超过4个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("管理费的收取服务项目：1社保2公积金3商险4薪酬")
	private String manageServerItem;

	/**
	 * 风险金的收取服务项目：1社保2公积金3商险4薪酬
	 */
	@ExcelAttribute(name = "风险金的收取服务项目：1社保2公积金3商险4薪酬"  , maxLength = 4 )
	@Length(max=4,message = "风险金的收取服务项目：1社保2公积金3商险4薪酬不能超过4个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("风险金的收取服务项目：1社保2公积金3商险4薪酬")
	private String riskServerItem;

	/**
	 * 单位大病比例
	 * hgw 2022-9-8 15:40:18
	 * 从t_depart_settlement_info表迁移过来的
	 */
	@ExcelAttribute(name = "单位大病比例")
	@DecimalMax(value = "100.00", message = "单位大病比例不能大于100.00")
	@Schema(description = "单位大病比例", name = "unitSeriousIllnessProp")
	private BigDecimal unitSeriousIllnessProp;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;

	/**
	 * EKP的服务团队 :  存
	 */
	@Schema(description = "EKP的服务团队", name = "serviceTeam")
	@ExcelIgnore
	@TableField(exist = false)
	private String serviceTeam;
	/**
	 * 条线类型
	 */
	@Schema(description = "条线类型")
	private String lineType;
	/**
	 * BU归属
	 */
	@Schema(description = "BU归属")
	private String buBelong;

	@Schema(description = "一级指标归属", name = "firstIndicatorBelong")
	private String firstIndicatorBelong ;

	@Schema(description = "二级指标归属", name = "secondIndicatorBelong")
	private String secondIndicatorBelong ;

	/**
	 * 是否含风险 fxj 2025-01-10 v1.7.5
	 */
	@Schema(description = "是否含风险",name = "hasContainRisks")
	private String hasContainRisks;
	/**
	 * 事业部条线 fxj 2025-01-10 v1.7.5
	 */
	@Schema(description = "事业部条线",name = "newLine")
	private String newLine ;
	/**
	 * 事业部 fxj 2025-01-10 v1.7.5
	 */
	@Schema(description = "事业部",name = "division")
	private String division ;
	/**
	 * 代发户状态（0否；1是代发户）
	 */
	@Schema(description ="代发户状态（0否；1是代发户）")
	private Integer issueStatus;
}
