package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAttaInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 附件信息表
 *
 * @author pwang
 * @date 2021-02-19 16:16:07
 */
@Mapper
public interface TAttaInfoMapper extends BaseMapper<TAttaInfo> {
    /**
     * 附件信息表简单分页查询
     *
     * @param tAttaInfo 附件信息表
     * @return
     */
    IPage<TAttaInfo> getTAttaInfoPage(Page<TAttaInfo> page, @Param("tAttaInfo") TAttaInfo tAttaInfo);

    /**
     * @param tAttaInfo
     * @Description: 获取list
     * @Author: hgw
     * @Date: 2021/5/28 16:02
     * @return: java.util.List<com.yifu.cloud.v1.crm.api.entity.TAttaInfo>
     **/
    List<TAttaInfo> getTAttaInfoList(@Param("tAttaInfo") TAttaInfo tAttaInfo);

    List<TAttaInfo> getTAttaInfoListByDoMainId(@Param("domainId") String domainId);

    List<TAttaInfo> getKeenAtta(@Param("dayStart")LocalDateTime dayStart, @Param("values")Collection<String> values);

    int updateDomainId(@Param("domainId")String domainId, @Param("ids")List<String> ids);

	List<TAttaInfo> getAttaByApplyId(@Param("applyId")String applyId);

	void deleteByDomainId(@Param("domainId") String domainId);

	void deleteByDomainIdAndType(@Param("domainId") String domainId, @Param("relationType") String relationType);

	// 删除学历与职业资格之外的附件
	void deleteByDomainIdAndOther(@Param("domainId") String domainId);

	List<TAttaInfoVo> getAttInfoByParam(@Param("departNo")String departNo, @Param("startDate")String startDate, @Param("endDate")String endDate);

	int getAttInfoCountByParam(@Param("departNo")String departNo, @Param("startDate")String startDate, @Param("endDate")String endDate);
}
