/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.pig4cloud.plugin.excel.vo.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 人员档案表
 *
 * @author hgw
 * @date 2022-06-20 09:55:06
 */
public interface TEmployeeInfoService extends IService<TEmployeeInfo> {

	/**
	 * @param employeeInfo
	 * @Description: 分页查询
	 * @Author: hgw
	 * @Date: 2022/6/20 20:46
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	IPage<TEmployeeInfo> getPage(Page<TEmployeeInfo> page, TEmployeeInfo employeeInfo);

	/**
	 * @Description: 离职库分页
	 * @Author: hgw
	 * @Date: 2022/7/4 17:38
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	IPage<TEmployeeInfo> getLeavePage(Page<TEmployeeInfo> page, TEmployeeInfo employeeInfo);

	/**
	 * @param employeeInfo
	 * @Description: 获取list
	 * @Author: hgw
	 * @Date: 2022/6/21 11:56
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	List<TEmployeeInfo> getList(TEmployeeInfo employeeInfo);

	/**
	 * @Description: code：2 ： 该人员在离职库已存在，是否'恢复档案'?
	 * 其余code就是成功失败，
	 * 200成功，可以下一步。
	 * @Author: hgw
	 * @Date: 2022/6/21 15:36
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	R<TEmployeeInfo> checkIdCard(TEmployeeInfo employeeInfo);

	/**
	 * @Description: 获取员工主码
	 * @Author: hgw
	 * @Date: 2024/6/19 15:11
	 * @return: java.lang.String
	 **/
	String getCode();

	/**
	 * @param employeeInfo
	 * @Description: 新增档案，附带新增项目档案、学历信息
	 * @Author: hgw
	 * @Date: 2022/6/21 18:31
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> addNewEmployee(TEmployeeInfo employeeInfo);

	/**
	 * @param tEmployeeInfo
	 * @Description: 更新档案信息
	 * @Author: hgw
	 * @Date: 2022/6/21 19:29
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	R<Boolean> updateEmployee(TEmployeeInfo tEmployeeInfo);

	/**
	 * @param id
	 * @Description: 删除
	 * @Author: hgw
	 * @Date: 2022/6/21 19:50
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> deleteEmployee(String id);

	/**
	 * @Description: 批量删除
	 * @Author: hgw
	 * @Date: 2022/6/23 16:45
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<List<ErrorMessageVO>> batchDeleteEmployee(List<String> idList);

	/**
	 * @param id
	 * @Description: 减档
	 * @Author: hgw
	 * @Date: 2022/6/21 19:50
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> minusEmployee(String id, String leaveReason, String leaveRemark);

	/**
	 * @param id
	 * @Description: 恢复档案
	 * @Author: hgw
	 * @Date: 2022/6/23 17:31
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> restoreEmployee(String id, String projectIds);

	/**
	 * @Description: 批量减档
	 * @Author: hgw
	 * @Date: 2022/6/23 17:12
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.pig4cloud.plugin.excel.vo.ErrorMessage>>
	 **/
	R<List<ErrorMessageVO>> batchMinusEmployee(InputStream inputStream);

	/**
	 * @param employeeInfo 档案信息
	 * @param fileSource   人员档案来源(4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬)
	 * @Description: 新增人员档案，其他服务新增时调用
	 * @Author: hgw
	 * @Date: 2022/6/21 19:03
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	R<TEmployeeInfo> saveNewEmpLoyee(TEmployeeInfo employeeInfo, String fileSource);

	/**
	 * @Description: 批量导入人员档案
	 * @Author: hgw
	 * @Date: 2022/6/22 11:58
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.pig4cloud.plugin.excel.vo.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> batchImportEmployee(InputStream inputStream, int isCanAdd);

	/**
	 * @Description: 批量更新人员档案
	 * @Author: hgw
	 * @Date: 2022/6/22 20:30
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.pig4cloud.plugin.excel.vo.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> batchUpdateEmployee(InputStream inputStream,String[] exportFields);

	// 批量更新人员和银行信息
	R<List<PreUploadEmpImportTwoVo>> batchUpdateEmployeeAndBank(MultipartFile file, PreUploadImportParamVo paramVo) throws Exception ;

	void updateEducationOfEmp(EmpEducationUpdateVO education);

	/**
	 * @param employeeVo
	 * @Description: 批量导出人员档案
	 * @Author: hgw
	 * @Date: 2022/6/23 10:30
	 **/
	void exportEmployee(EmployeeInfoSearchVo employeeVo, HttpServletResponse response);

	/**
	 * @param employeeVo
	 * @Description: 批量导出离职档案
	 * @Author: hgw
	 * @Date: 2022-6-24 09:35:54
	 **/
	void exportLeaveEmployee(EmployeeInfoSearchVo employeeVo, HttpServletResponse response);

	Map<String,DispatchEmpVo> getDispatchEmpVo(DispatchCheckVo checkVo);

	EmpDispatchAddVo addDispatchInfo(EmpDispatchAddVo addVo);

	Boolean updateEmpInfo(UpdateEmpVo vo) throws IllegalAccessException;

	Boolean checkMobile(String mobile);

	// 未删除的档案
	TEmployeeInfo getInfoByIdcard(String idcard);

	// 已删除的档案
	TEmployeeInfo getInfoByDelete(String idcard);

	/**
	 * @Description: 更新人员档案的商险状态
	 * @Author: hgw
	 * @Date: 2022/11/23 17:20
	 * @return: java.lang.Boolean
	 **/
	Boolean updateEmployeeInfoInsuranceStatus(EmpStatusVo vo);

	/**
	 * @Description: 更新人员档案的薪资状态
	 * @Author: hgw
	 * @Date: 2022/11/24 11:35
	 * @return: java.lang.Boolean
	 **/
	Boolean updateEmployeeInfoSalaryStatus(EmpStatusVo vo);

	/**
	 * @Description: 每月1号更新人员档案、项目档案的薪资状态
	 * @Author: hgw
	 * @Date: 2022/11/24 14:57
	 * @return: void
	 **/
	void everyMonthUpdateSalaryStatus();

	/**
	 * @Description: 每天更新人员档案、项目档案的过期合同为2不在用
	 * @Author: hgw
	 * @Date: 2022/11/24 14:57
	 * @return: void
	 **/
	void everyDayUpdateEmployeeContractStatus();

    void updateContractStatus(String empId, int status);

	/**
	 * @param idCard
	 * @Description: HCM获取人员信息
	 * @Author: hgw
	 * @Date: 2023/11/23 11:35
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.vo.HcmEmployeeInfoVO
	 **/
	R<HcmEmployeeInfoVO> getHcmEmpInfo(String idCard);

	/**
	 * @param idCardList
	 * @Description: HCM获取人员信息列表
	 * @Author: hgw
	 * @Date: 2023/11/23 11:35
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.vo.HcmEmployeeInfoVO>
	 **/
	R<List<HcmEmployeeInfoVO>> getHcmEmpInfoList(List<String> idCardList);

	void updateEmployeeAgeTask();

	IPage<TEmployeeInfo> getPageAsso(Page<TEmployeeInfo> page, TEmployeeInfo tEmployeeInfo);

	R<TEmployeeInfo> getByIdAssociate(String id);

	void exportEmployeeFile(String id, HttpServletResponse response) throws Exception;

	// 预入职批量导入使用
	List<TEmployeeInfo> getListByIdCardList(List<String> idList);

	List<TEmployeeInfo> getListByDeptIdByLimit(String deptId, Integer limit1, Integer limit2);

}
