package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TAttaInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAttaInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAttaInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 附件信息表
 *
 * @author pwang
 * @date 2021-02-19 16:16:07
 */
@Service
public class TAttaInfoServiceImpl extends ServiceImpl<TAttaInfoMapper, TAttaInfo> implements TAttaInfoService {

    @Autowired
    private OSSUtil ossUtil;

    /**
     * 附件信息表简单分页查询
     *
     * @param tAttaInfo 附件信息表
     * @return
     */
    @Override
    public IPage<TAttaInfo> getTAttaInfoPage(Page<TAttaInfo> page, TAttaInfo tAttaInfo) {
        return baseMapper.getTAttaInfoPage(page, tAttaInfo);
    }

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    @Override
    public List<TAttaInfo> getTAttaInfoList(TAttaInfo tAttaInfo) {
        return baseMapper.getTAttaInfoList(tAttaInfo);
    }
    @Override
    public List<TAttaInfo> getTAttaInfoListByDoMainId(String domainId) {
        return baseMapper.getTAttaInfoListByDoMainId(domainId);
    }

    @Override
    public TAttaInfo add(TAttaInfo attaInfo) {
        this.save(attaInfo);
        return attaInfo;
    }

	/**
	 * @Author fxj
	 * @Description
	 * @Date 13:48 2022/6/17
	 * @Param
	 * @return
	**/
    @Override
    public void update(List<TAttaInfo> attaInfoList, String domainId, String relationType) {
        if (attaInfoList != null) {
            for (TAttaInfo attaInfo : attaInfoList) {
                attaInfo.setDomainId(domainId);
                attaInfo.setRelationType(relationType);
                this.updateById(attaInfo);
            }
        }
    }

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    @Override
    public Boolean batchOssFileDelete(List<TAttaInfo> delAttaList) {
        try {
            for (TAttaInfo delAtta : delAttaList) {
                if (this.removeById(delAtta.getId())) {
                    ossUtil.deleteObject(null, delAtta.getAttaSrc());
                }
            }
            return true;
        } catch (Exception e) {
            log.error("附件删除异常：" + e.getMessage());
            return false;
        }
    }

    @Override
    public List<TAttaInfo> getKeenAtta(LocalDateTime dayStart, Collection<String> values) {
        return baseMapper.getKeenAtta(dayStart,values);
    }
	@Override
	public Boolean updateDomainId(String domainId, List<String> ids){
		if (Common.isEmpty(domainId) || !Common.isNotEmpty(ids)){
			return false;
		}
		return  baseMapper.updateDomainId(domainId,ids) > 0;
	}

	@Override
	public R<List<TAttaInfo>> getAttaByApplyId(String applyId) {
		List<TAttaInfo> list = baseMapper.getAttaByApplyId(applyId);
		if (Common.isNotNull(list)) {
			URL url;
			for (TAttaInfo atta:list) {
				url = ossUtil.getObjectUrl(null, atta.getAttaSrc());
				atta.setAttaUrl(url.toString());
			}
			return R.ok(list);
		}else{
			return R.failed("没有附件");
		}
	}

	@Override
	public void deleteByDomainId(String domainId) {
		baseMapper.deleteByDomainId(domainId);
	}

	@Override
	public void deleteByDomainIdAndOther(String domainId) {
		baseMapper.deleteByDomainIdAndOther(domainId);
	}

	@Override
	public void deleteByDomainIdAndType(String domainId, int relationType) {
		// 学历
		if (relationType == 0) {
			baseMapper.deleteByDomainIdAndType(domainId, "0");
			baseMapper.deleteByDomainIdAndType(domainId, "26");
		} else if (relationType == 1) {
			// 执业资格证书
			baseMapper.deleteByDomainIdAndType(domainId, "2");
		} else if (relationType == 2) {
			// 其他附件
			baseMapper.deleteByDomainIdAndType(domainId, "27");
		}
	}

	@Override
	public List<TAttaInfoVo> getAttInfoByParam(String departNo, String startDate, String endDate) {
		return baseMapper.getAttInfoByParam(departNo,startDate,endDate);
	}
	@Override
	public int getAttInfoCountByParam(String departNo, String startDate, String endDate) {
		return baseMapper.getAttInfoCountByParam(departNo,startDate,endDate);
	}

}
