package com.yifu.cloud.plus.v1.check.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;


/**
 * 实名校验导入锁定表（锁定后不可导入，除非清理掉数据）
 *
 * @author hgw
 * @date 2022-6-10 11:07:15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_check_lock")
@Schema(description = "实名校验导入锁定表（锁定后不可导入，除非清理掉数据）")
public class TCheckLock extends Model<TCheckLock> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 创建人
      */
     @NotBlank(message = "创建人不能为空")
     @Length(max = 32, message = "创建人不能超过32个字符")
     @Schema(description = "创建人")
     private String createUser;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 校验月
      */
     @Length(max = 6, message = "校验月不能超过6个字符")
     @Schema(description = "校验月")
     private String createMonth;
     /**
      * 导入总条数
      */
     @NotNull(message = "导入总条数不能为空")
     @Schema(description = "导入总条数")
     private Integer importNum;
     /**
      * 调用API总条数
      */
     @NotNull(message = "调用API总条数不能为空")
     @Schema(description = "调用API总条数")
     private Integer apiNum;
     /**
      * 删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）
      */
     @NotNull(message = "删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）不能为空")
     @Schema(description = "删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）")
     private Integer deleteFlag;
}
