/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.common.core.constant;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author lengleng
 * @date 2019/2/1
 */
public interface CommonConstants {

	/**
	 * 删除
	 */
	String STATUS_DEL = "1";

	/**
	 * 正常
	 */
	String STATUS_NORMAL = "0";

	/**
	 * 锁定
	 */
	String STATUS_LOCK = "9";

	/**
	 * 菜单树根节点
	 */
	Long MENU_TREE_ROOT_ID = -1L;

	/**
	 * 部门根节点
	 */
	Long DEPT_TREE_ROOT_ID = 0L;

	/**
	 * 1L
	 */
	Long LONG_1 = 1L;

	/**
	 * 菜单
	 */
	String MENU = "0";

	/**
	 * 编码
	 */
	String UTF8 = "UTF-8";

	/**
	 * JSON 资源
	 */
	String CONTENT_TYPE = "application/json; charset=utf-8";

	/**
	 * 前端工程名
	 */
	String FRONT_END_PROJECT = "yifu-ui";

	/**
	 * 后端工程名
	 */
	String BACK_END_PROJECT = "yifu";

	/**
	 * 获取一条数据的后缀
	 */
	String LAST_ONE_SQL = " limit 1";

	/**
	 * 成功标记
	 */
	Integer SUCCESS = 200;

	/**
	 * 商险导出最大值
	 */
	Integer EXPORT_TWENTY_THOUSAND = 20000;

	/**
	 * 商险导入最大值
	 */
	Integer IMPORT_TWENTY_THOUSAND = 20000;

	/**
	 * 失败标记
	 */
	Integer FAIL = 1;

	/**
	 * 验证码前缀
	 */
	String DEFAULT_CODE_KEY = "DEFAULT_CODE_KEY_";

	/**
	 * 当前页
	 */
	String CURRENT = "current";

	/**
	 * size
	 */
	String SIZE = "size";

	/**
	 * JSON 资源
	 */

	/**
	 * number 0
	 */
	String ZERO_STRING = "0";

	String FOUR_STRING = "4";

	String FIVE_STRING = "5";

	String TWELVE_STRING = "12";

	String ELEVEN_STRING = "11";

	int TWELVE_INT = 12;

	String THIRTEEN_STRING = "13";

	String FOURTEEN_STRING = "14";

	String FIFTEEN_STRING = "15";

	String SIXTEEN_STRING = "16";

	String TWENTY_TWO_STRING = "22";

	String TWENTY_THREE_STRING = "23";

	String TWENTY_FOUR_STRING = "24";

	String TWENTY_FIVE_STRING = "25";

	String TWENTY_SEVEN_STRING = "27";

	public static final String DEFAULT_PASSWORD = "123456";

	/**
	 * number 0
	 */
	String ZERO_ONE = "01";

	/**
	 * number 0
	 */
	int ZERO_INT = 0;

	/**
	 * number 5000
	 */
	int FIVES_INT = 5000;
	/**
	 * number 5000
	 */
	int TEN_THOUSAND_INT = 10000;

	/**
	 * number 1000
	 */
	int ONE_THOUSAND_INT = 1000;

	/**
	 * number 1
	 */
	String ONE_STRING = "1";

	/**
	 * number 2
	 */
	String TWO_STRING = "2";

	/**
	 * number 3
	 */
	String THREE_STRING = "3";

	/**
	 * 数字int 3
	 */
	int THREE_INT = 3;

	/**
	 * 下划线
	 * hgw 2022-6-9 17:36:35
	 */
	String DOWN_LINE_STRING = "_";
	/**
	 * 空字符串
	 * hgw 2022-6-9 17:36:35
	 */
	String EMPTY_STRING ="";

	/**
	 * 数字int 1
	 * @author fxj
	 */
	int ONE_INT = 1;
	int TWO_INT = 2;

	/**
	 * 个位数字（阿里编码规约不允许直接使用‘魔法值’）
	 * @Author pwang
	 * @Date 2019-08-02 16:39
	 **/
	int[] dingleDigitIntArray = {0,1,2,3,4,5,6,7,8,9,10,11,12};
	/**
	 * 个位数字串（阿里编码规约不允许直接使用‘魔法值’）
	 * @Author pwang
	 * @Date 2019-08-02 16:39
	 **/
	String[] dingleDigitStrArray = {"0","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17"};

	/**
	 * 月份（阿里编码规约不允许直接使用‘魔法值’）
	 * @Author zhaji
	 * @Date 2022-07-28 16:39
	 **/
	String[] MonthStrArray = {"0","1","2","3","4","5","6","7","8","9","10","11","12"};


	/**
	 * 逗号
	 * @Author fxj
	 **/
	char COMMA_CHAR = ',';

	char SPOT_CHAR = '.';
	/**
	 * 100
	 * @Author fxj
	 **/
	int INTEGER_HUNDRED = 100;

	//,逗号
	String COMMA_STRING = ",";

	//、顿号
	String DUNHAO_STRING = "、";
	//- 横
	char DOWN_LINE_CHAR ='_';
	// 冒号 ：
	String COLON_STRING =":";
	// - 横 分割线 中
	String CENTER_SPLIT_LINE_STRING = "-";
	// 斜杠
	String SLASH_SPLIT_LINE_STRING = "/";
	// = 等
	char ETC_CHAR = '=';
	// = 等
	String ETC_STRING = "=";
	//+ 加
	char ADD_CHAR = '+';
	//int 4
	int FOUR_INT = 4;
	//int 5
	int FIVE_INT = 5;
	String TEN_STRING = "10";

	int SEVEN_INT = 7;

	public static final String SPOT = ".";

	int FIFTY_INT = 50;

	int BYTE = 1024;

	/**
	 * 员工初始序列
	 * @Author pwang
	 * @Date 2020-05-14 11:13
	 * @param null
	 * @return
	 **/
	public static final String EMPLOYEE_INIT_NO = "0001";

	/**
	 *  员工的的前缀位数
	 * @Author pwang
	 * @Date 2020-05-14 14:10
	 **/
	int EMPLOYEE_INIT_NO_START = 7;

	String SAVE_FAILED = "保存失败！";

    String RESULT_EMPTY = "获取结果为空";

	//错误信息
	String ERROR_NO_DOMAIN = "无此实体！";

	String NULL = null;

	/**
	 * @Author fxj
	 * @Date 2020-03-12 14:48
	 * @return
	 **/
	String RESULT_DATA_FAIL= "操作失败";

	String RESULT_DATA_SUCESS= "操作成功";

	String SAVE_SUCCESS = "保存成功！";

	String UPDATE_SUCCESS = "更新成功！";

	/**
	 * update fail
	 * @Author fxj
	 * @Date  2020-08-25
	 **/
	String UPDATE_DATA_FAIL = "更新失败！";

	String ID_CARD_IS_NULL =  "身份证号为空";

	String PARAM_IS_NOT_EMPTY = "参数不可为空";

	String DATA_CAN_NOT_EMPTY = "数据不可为空";

	String NO_DATA_TO_HANDLE = "无数据可操作！";

	String DATA_TOO_LARGER_FOR_DOWN = "下载数据超出100M，请重新选择下载条件！";

	String PLEASE_LOG_IN = "请登录！";

	String SEX_MAN = "1";
	String SEX_WONMAN = "2";
	String SALARY_ISFLAG = "已结算";
	String SALARY_UNFLAG = "未结算";

	// 是否
	String IS_FALSE = "否";
	String IS_TRUE = "是";
	int SIX_INT = 6;
	int EIGHT_INT = 8;

	public static final String ZIP_TYPE = "zip";

	public static final String JAR_TYPE = "jar";
	int BATCH_COUNT = 100;
	int BATCH_COUNT1 = 2000;
	String IMPORT_DATA_ANALYSIS_ERROR = "数据导入解析异常，请检查表数据格式（常见错误：1.日期格式:yyyy-MM-dd,2.比例为整数且不含%）";

	String IMPORT_DATA_ANALYSIS_ERROR_TWO = "数据导入解析异常，请检查表数据格式";
    String CREATE_TIME = "CREATE_TIME";
	String ID = "ID";
	String PARAM_IS_NOT_ERROR = "传参异常，请检查参数";
	int EXCEL_EXPORT_LIMIT = 60000;

	int EXCEL_EXPORT_LIMIT_NEW = 20000;
	// 给量大的表导出使用
	int EXCEL_EXPORT_LIMIT_3 = 30000;

	int EXCEL_EXPORT_LIMIT_1 = 10000;

	int EXCEL_EXPORT_LIMIT_2 = 20000;

	String USER = "用户";

	/**
	 * multipart/form-data
	 * @Author fxj
	 * @Date  2020-10-13
	 **/
	public static final String MULTIPART_FORM_DATA = "multipart/form-data";

	/**
	 * Content-Disposition
	 * @Author fxj
	 * @Date  2020-10-13
	 **/
	public static final String CONTENT_DISPOSITION = "Content-Disposition";

	/**
	 * attachment;filename=
	 * @Author fxj
	 * @Date  2020-10-13
	 **/
	public static final String ATTACHMENT_FILENAME =  "attachment;filename=";
	/**
	 * USER_AGENT
	 * @Author fxj
	 * @Date  2020-10-26
	 **/
	public static final String USER_AGENT  = "USER-AGENT";

	/**
	 * 成功颜色
	 */
	String GREEN = "green";

	/**
	 * 失败颜色
	 */
	String RED = "red";

	/**
	 * 数字int -1
	 * @author fxj
	 */
	int ONE_INT_NEGATE = -1;

	/**
	 * 数字int -1
	 * @author fxj
	 */
	String ONE_STRING_NEGATE = "-1";

	/**
	 * 数字int -1
	 * @author fxj
	 */
	int TWO_INT_NEGATE = -2;

	/**
	 * 数字int -1
	 * @author fxj
	 */
	int THREE_INT_NEGATE = -3;

	// 是否
	String IS_CHANGE = "划转";

	String IS_NO_CHANGE = "不划转";

	// 年
	String YEAR = "年";
	// 月
	String MONTH = "月";
	// 日
	String DAY = "日";

	/**
	 * 一年365天
	 */
	int ONE_YEAR = 366;

	/**
	 * 数字70
	 */
	int SEVENTY = 70;

	/**
	 * 省市
	 * @Author fxj
	 * @Date  2020-08-25
	 **/
	public static final  String HEFEISTRING="安徽省-合肥市";

	/**
	 * 省
	 * @Author fxj
	 * @Date  2020-08-25
	 **/
	public static final  String ANHUISTRING="安徽省";

	/**
	 *是所有者
	 **/
	public static final String IS_OWNER_YES = "0";
	/**
	 *不是所有者
	 **/
	public static final String IS_OWNER_NO = "1";

	/**
	 * 获取登录用户信息失败
	 **/
	public static final String USER_FAIL = "获取登录用户信息失败！";

	public static final int SIXTEEN_INT = 16;
	public static final String FIFTEEN = "15";
	public static final String NINETEEN = "19";
	public static final String NINE_STRING = "9";
	String EIGHT_STRING = "8";

	public static final String PAYMENT_SOCIAL_IMPORT = "payment_social_import";

	public static final String PAYMENT_SOCIAL_WAIT_EXPORT = "payment_social_wait_export";

	//百分之一 1/100
	public static final BigDecimal ONE_OF_PERCENT = new BigDecimal("0.01");

	// 1/2
	public static final BigDecimal HALF_OF_ONE = new BigDecimal("0.5");
	public static final BigDecimal TWO_BIG = new BigDecimal("2");

	String SIX_STRING = "6";
	String SEVEN_STRING = "7";

	/**
	 * 工资最大不能超过9999999.99
	 */
	public static final BigDecimal MONEY_MAX = new BigDecimal("9999999.99");

	/**
	 * 工资最小不能小于零
	 */
	public static final BigDecimal MONEY_MIN = new BigDecimal(0);

	public static final int TWENTY_INT = 20;

	public static final String TWENTY_STRING = "20";

	public static final String TWENTY_ONE_STRING = "21";

	public static final String ERROR_MSG_PRFIX = "error=";

	public static final String SUCCESS_MSG_PREFIX = "success=";

	// 社保细分类型 hgw 2021-6-9 17:54:08
	public static final String[] SOCIAL_HANDLE_TYPE = {"0","养老", "医疗", "失业", "工伤", "生育", "大病"};

	public static final int SIXTY_INT = 60;

	/**
	 * param error
	 * @Author fxj
	 * @Date  2020-08-25
	 **/
	public static final String PARAM_INFO_ERROR = "传参有误！";


	public static final String XLS = ".xls";
	public static final String XLSX = ".xlsx";
	public static final String ERROR_IMPORT = "执行异常";
	// 权限使用的
	public static final String A_DEPT_ID = "a.dept_id";
	public static final String A_CREATE_BY = "a.CREATE_BY";

	String SETTLE_DOMAIN_GET_ERROR = "获取结算主体信息失败！";

	String SETTLE_DOMAIN_NOT_EXIST = "无对应项目信息";

	/**
	 *  c端机构节点 code
	 * @Author hgw
	 * @Date 2022-12-13 11:05:24
	 **/
	public static final String WX_C_ORG_CODE = "00294";
	/**
	 *  c端机构节点 id
	 * @Author hgw
	 * @Date 2022-12-13 11:05:33
	 **/
	public static final long WX_C_ORG_ID = 294;

	/**
	 *  c端机构节点 name
	 * @Author hgw
	 * @Date 2022-12-13 11:05:33
	 **/
	public static final String WX_C_ORG_NAME = "C端用户";

	// C端前缀
	public static final String C_PREFIX = CacheConstants.DEFAULT_CODE_KEY.concat("_C_");

	/**
	 * 用户未注册
	 */
	public static final Integer REGISTERED = 3;

	/**
	 *  b端机构节点
	 * @Author fxj
	 **/
	public static final long HR_B_ORG_ID = 295;

	public static final String TAG_FROMAT = "%04d";
	/**
	 * SEARCH SUCESS
	 * @Author fxj
	 * @Date  2020-10-13
	 **/
	public static final String SEARCH_SUCCESS = "查询成功！";

	String NO_SETTLE_DOMAIN_AUTH =  "Hro系统中身份证号不存在,或者没有该人员的结算主体权限";
	String HRO_EMPLOYEE_NULL =  "Hro人员列表为空";
	int THIRTY_INT_NEGATIVE = -30;

	public static final String SOCIAL_EXPORT_CONTINUE="当前用户有未完成的实缴导出任务不可重复操作";

	public static final String SOCIAL_EXPORT_LIMIT="导出量过大，请选择更多查询条件！如果确定要导出这些数据请联系系统管理员操作";

	/*
	 * 启用停用状态
	 */

	String START =  "启用";
	String STOP  =  "停用";


	String CONTRACT_TYPE_TWO="无固定期限";
	String CONTRACT_TYPE_ZERO="已完成一定工作任务为期限";


	Integer ZERO_INTEGER = 0;
	Integer ONE_INTEGER = 1;
	Integer TWO_INTEGER = 2;
	Integer THREE_INTEGER = 3;
	Integer FOUR_INTEGER = 4;
	Integer FIVE_INTEGER =5;
	Integer SIX_INTEGER = 6;
	Integer SEVEN_INTEGER  = 7;
	Integer EIGHT_INTEGER =8;

	Integer NINE_INTEGER = 9;
	Integer TEN_INTEGER  = 10;
	Integer ELEVEN_INTEGER =11;

	List<String> socialStatus = Stream.of("3","4","6","7","9","11","12").collect(Collectors.toList());

	List<String> socialInfoStatus = Stream.of("1","3","5","7").collect(Collectors.toList());

	List<String> deptList = Stream.of("安徽一册档案管理有限公司","安徽顾合企业管理咨询有限公司","安徽赤道线数字传媒科技有限公司","劳务业务中心","易服智享&研究院").collect(Collectors.toList());

	String USER_DIR = "user.dir";
	String DOUBLE_LINE = "//";

	public static final int THIRTY_INT = 30;
	public static final int TWENTY_SEVEN_INT = 27;

	/**
	 *未删除标志
	 **/
	public static final String NOT_DELETE_FLAG = "0";
	/**
	 *已删除标志
	 **/
	public static final String DELETE_FLAG = "1";
	//单条数据检索SQL
	public static final String SQL_LIMIT_ONE = " limit 1 ";
}
