package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 远程服务调用（在节点为服务调用节点时使用）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_service_transfer_config")
@Schema(description = "远程服务调用（在节点为服务调用节点时使用）")
public class TServiceTransferConfig extends Model<TServiceTransferConfig> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;

     @NotBlank(message = "服务协议（0jaxws/1jaxrs）不能为空")
     @Length(max = 1, message = "服务协议（0jaxws/1jaxrs）不能超过1个字符")
	 @Schema(description = "服务协议（0jaxws/1jaxrs）")
     private String serviceAgreement;

     @NotBlank(message = "调用方式（0同步/1异步）不能为空")
     @Length(max = 1, message = "调用方式（0同步/1异步）不能超过1个字符")
	 @Schema(description = "调用方式（0同步/1异步）")
     private String transferType;

     @NotBlank(message = "WSDL地址不能为空")
     @Length(max = 255, message = "WSDL地址不能超过255个字符")
	 @Schema(description = "WSDL地址")
     private String wsdlAddress;

     @Length(max = 255, message = "调用方法不能超过255个字符")
	 @Schema(description = "调用方法")
     private String transferFunc;

     @NotBlank(message = "节点ID不能为空")
     @Length(max = 255, message = "节点ID不能超过255个字符")
	 @Schema(description = "节点ID")
     private String nodeId;
}
