/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandard;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 标准薪酬工资表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Mapper
public interface TSalaryStandardMapper extends BaseMapper<TSalaryStandard> {
    /**
     * 标准薪酬工资表简单分页查询
     * @param tSalaryStandard 标准薪酬工资表
     * @return
     */
    IPage<TSalaryStandard> getTSalaryStandardPage(Page<TSalaryStandard> page, @Param("tSalaryStandard") TSalaryStandard tSalaryStandard);

	IPage<TSalaryStandard> getTSalaryStandardPageApply(Page<TSalaryStandard> page, @Param("tSalaryStandard") TSalaryStandard tSalaryStandard);
	/**
	 * 标准薪酬工资表审核页面简单分页查询
	 * @param tSalaryStandard 标准薪酬工资表
	 * @return
	 */
	IPage<TSalaryStandard> getTSalaryStandardAuditPage(Page<TSalaryStandard> page, @Param("tSalaryStandard") TSalaryStandard tSalaryStandard);

	List<TSalaryStandardExportVo> getSalaryStandardExport(@Param("searchVo") TSalaryStandardSearchVo searchVo, @Param("idList")List<String> idList);

	int getSalaryStandardExportCount(@Param("searchVo") TSalaryStandardSearchVo searchVo, @Param("idList")List<String> idList);

	/**
	 * @Description: 获取当日薪酬最大编码
	 * @Author: hgw
	 * @Date: 2022-11-2 11:09:25
	 * @return: java.lang.String
	 **/
	String getMaxSalaryCode();

	/**
	 * @param deptId 项目id
	 * @param settleMonth 结算月
	 * @param nowYear 当前结算年
	 * @Description:  获取薪资条数
	 * @Author: hgw
	 * @Date: 2023/6/25 18:04
	 * @return: int
	 **/
	int getNum(@Param("deptId") String deptId, @Param("setId") String setId, @Param("settleMonth") String settleMonth, @Param("nowYear") String nowYear);
}
