/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialSoldierLog;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TSocialSoldierLogMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialSoldierLogService;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * 自动化日志
 *
 * @author hgw
 * @date 2024-08-30 10:27:16
 */
@Log4j2
@Service
public class TSocialSoldierLogServiceImpl extends ServiceImpl<TSocialSoldierLogMapper, TSocialSoldierLog> implements TSocialSoldierLogService {
	/**
	 * 自动化日志简单分页查询
	 *
	 * @param tSocialSoldierLog 自动化日志
	 * @return
	 */
	@Override
	public IPage<TSocialSoldierLog> getTSocialSoldierLogPage(Page<TSocialSoldierLog> page, TSocialSoldierLogSearchVo tSocialSoldierLog) {
		return baseMapper.getTSocialSoldierLogPage(page, tSocialSoldierLog);
	}

	/**
	 * 自动化日志批量导出
	 *
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TSocialSoldierLogSearchVo searchVo) {
		String fileName = "自动化日志批量导出" + DateUtil.getThisTime() + ".xlsx";
		//获取要导出的列表
		List<TSocialSoldierLogExportVo> list = new ArrayList<>();
		long count = noPageCountDiy(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, CommonConstants.UTF8));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcelFactory.write(out, TSocialSoldierLogExportVo.class).build();
			int index = 0;
			WriteSheet writeSheet;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.getTSocialSoldierLogList(searchVo);
					if (Common.isNotNull(list)) {
						writeSheet = EasyExcelFactory.writerSheet("自动化日志" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				writeSheet = EasyExcelFactory.writerSheet("自动化日志" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	@Override
	public List<TSocialSoldierLog> noPageDiy(TSocialSoldierLogSearchVo searchVo) {
		LambdaQueryWrapper<TSocialSoldierLog> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TSocialSoldierLog::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	@Override
	public TSocialSoldierLog getYgsSoldierLog(SocialSoldierYgsAddVo vo, String type, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(vo.getSocialId());
		log.setEmpName(vo.getEmpName());
		log.setEmpIdcard(vo.getEmpIdcard());
		log.setDispatchItem("社保");
		log.setSocialHuName(vo.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark(remark);
		return log;
	}

	@Override
	public TSocialSoldierLog getYsdSoldierLog(SocialSoldierYsdAddVo vo, String type, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(vo.getSocialId());
		log.setEmpName(vo.getEmpName());
		log.setEmpIdcard(vo.getEmpIdcard());
		log.setDispatchItem("医保");
		log.setSocialHuName(vo.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark(remark);
		return log;
	}

	@Override
	public TSocialSoldierLog getFriendLog(SociaFriendYgsAddVo vo, String type, String dispatchItem, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(vo.getSocialId());
		log.setEmpName(vo.getEmpName());
		log.setEmpIdcard(vo.getEmpIdcard());
		log.setDispatchItem(dispatchItem);
		log.setSocialHuName(vo.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark("【税友】" + remark);
		return log;
	}

	@Override
	public TSocialSoldierLog getYgsSoldierAuditLog(SocialSoldierYgsAuditVo vo, String type, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(vo.getSocialId());
		log.setEmpName(vo.getEmpName());
		log.setEmpIdcard(vo.getEmpIdcard());
		log.setDispatchItem("社保");
		log.setSocialHuName(vo.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark(remark);
		return log;
	}

	@Override
	public TSocialSoldierLog getYsdSoldierAuditLog(SocialSoldierYsdAuditVo vo, String type, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(vo.getSocialId());
		log.setEmpName(vo.getEmpName());
		log.setEmpIdcard(vo.getEmpIdcard());
		log.setDispatchItem("医保");
		log.setSocialHuName(vo.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark(remark);
		return log;
	}

	@Override
	public TSocialSoldierLog getSocialFriendLog(TSocialInfo social, String type, String dispatchItem, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(social.getId());
		log.setEmpName(social.getEmpName());
		log.setEmpIdcard(social.getEmpIdcard());
		log.setDispatchItem(dispatchItem);
		log.setSocialHuName(social.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark("【税友】" + remark);
		return log;
	}

	@Override
	public TSocialSoldierLog getSocialSoldierLog(TSocialInfo social, String type, String dispatchItem, String remark) {
		TSocialSoldierLog log = new TSocialSoldierLog();
		log.setSocialId(social.getId());
		log.setEmpName(social.getEmpName());
		log.setEmpIdcard(social.getEmpIdcard());
		log.setDispatchItem(dispatchItem);
		log.setSocialHuName(social.getSocialHouseholdName());
		// type 类型：提交；审核
		log.setType(type);
		log.setRemark(remark);
		return log;
	}

	private Long noPageCountDiy(TSocialSoldierLogSearchVo searchVo) {
		LambdaQueryWrapper<TSocialSoldierLog> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TSocialSoldierLog::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TSocialSoldierLogSearchVo entity) {
		LambdaQueryWrapper<TSocialSoldierLog> wrapper = Wrappers.lambdaQuery();
		if (ArrayUtil.isNotEmpty(entity.getCreateTimeStart())) {
			wrapper.ge(TSocialSoldierLog::getCreateTime, entity.getCreateTimeStart());
		}
		if (ArrayUtil.isNotEmpty(entity.getCreateTimeEnd())) {
			wrapper.le(TSocialSoldierLog::getCreateTime, entity.getCreateTimeEnd());
		}
		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TSocialSoldierLog::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
