package com.yifu.cloud.plus.v1.yifu.social.util;

import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.util.RedisUtil;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.EkpDaprUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.util.EkpFundUtil;
import com.yifu.cloud.plus.v1.yifu.ekp.util.EkpIncomeUtil;
import com.yifu.cloud.plus.v1.yifu.ekp.util.EkpSocialUtil;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamManage;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamRisk;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushFundParam;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushSocialParam;
import com.yifu.cloud.plus.v1.yifu.social.constants.SocialConstants;
import com.yifu.cloud.plus.v1.yifu.social.entity.*;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TForecastLibraryMapper;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TIncomeMapper;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TPaymentInfoMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentSocialPushService;
import com.yifu.cloud.plus.v1.yifu.social.service.TSendEkpErrorService;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoPushVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 主要执行人员档案的员工类型同步更新
 * @author huyc
 * @Date 2022-07-08
 * @Description 多线程的执行demo
 */
@Slf4j
@Component
public class DoJointSocialTask {

	@Autowired
	private EkpIncomeUtil ekpIncomeUtil;

	@Autowired
	private EkpSocialUtil ekpSocialUtil;

	@Autowired
	private EkpFundUtil ekpFundUtil;

	@Autowired
	private TSendEkpErrorService tSendEkpErrorService;

	@Autowired
	private TIncomeMapper incomeMapper;

	@Autowired
	private TPaymentInfoMapper paymentInfoMapper;

	@Autowired
	private TForecastLibraryMapper forecastLibraryMapper;

	@Autowired
	private TPaymentSocialPushService socialPushService;

	@Autowired
	private RedisUtil redisUtil;

	@Autowired
	private EkpDaprUtils ekpDaprUtil;

    /**
     * @Description: 合同-批量更换负责人
     * @Author: huyc
     * @Date: 2022-7-8
     * @return: void
     **/
    @Async
    public void asynchronousEkpIncome(TIncome income) {
        log.info("推送收入到EKP-线程开始");
        try {
			String sendBack = this.getSendBack(income);
			if ((Common.isEmpty(sendBack) || sendBack.length() != 19) && Common.isNotNull(income.getRedisKey())) {
				List<TIncome> list;
				if (Common.isNotNull(income.getRedisKey()) && Common.isNotNull(redisUtil.get(income.getRedisKey()))) {
					list = (List<TIncome>) redisUtil.get(income.getRedisKey());
				} else {
					list = new ArrayList<>();
				}
				list.add(income);
				redisUtil.set(income.getRedisKey(), list);
			}
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				incomeMapper.updateById(income);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
        } catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
            log.error("推送收入到EKP错误", e);
        }
        log.info("推送收入到EKP结束");
    }
	public void asynchronousEkpIncomeAsso(TIncome income) {
		log.info("推送收入到EKP-线程开始");
		try {
			String sendBack = this.getSendBack(income);
			if ((Common.isEmpty(sendBack) || sendBack.length() != 19) && Common.isNotNull(income.getRedisKey())) {
				List<TIncome> list;
				if (Common.isNotNull(redisUtil.get(income.getRedisKey()))) {
					list = (List<TIncome>) redisUtil.get(income.getRedisKey());
				} else {
					list = new ArrayList<>();
				}
				list.add(income);
				redisUtil.set(income.getRedisKey(),list);
			}
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				incomeMapper.updateById(income);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送收入到EKP错误", e);
		}
		log.info("推送收入到EKP结束");
	}

	/**
	 * @Description: 合同-批量更换负责人
	 * @Author: huyc
	 * @Date: 2022-7-8
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpIncomePayment(TIncome income,String paymentId) {
		log.info("推送收入到EKP-线程开始");
		try {
			String sendBack = this.getSendBack(income);
			if ((Common.isEmpty(sendBack) || sendBack.length() != 19) && Common.isNotNull(income.getRedisKey())) {
				List<TIncome> list;
				if (Common.isNotNull(redisUtil.get(income.getRedisKey()))) {
					list = (List<TIncome>) redisUtil.get(income.getRedisKey());
				} else {
					list = new ArrayList<>();
				}
				list.add(income);
				redisUtil.set(income.getRedisKey(),list);
			}
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				incomeMapper.updateById(income);
				paymentInfoMapper.updateBySocialIncomePayment(paymentId);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送收入到EKP错误", e);
		}
		log.info("推送收入到EKP结束");
	}

	public void asynchronousEkpIncomePaymentNew(TIncome income,String paymentId) {
		log.info("推送收入到EKP-线程开始");
		try {
			String sendBack = this.getSendBack(income);
			if ((Common.isEmpty(sendBack) || sendBack.length() != 19) && Common.isNotNull(income.getRedisKey())) {
				List<TIncome> list;
				if (Common.isNotNull(redisUtil.get(income.getRedisKey()))) {
					list = (List<TIncome>) redisUtil.get(income.getRedisKey());
				} else {
					list = new ArrayList<>();
				}
				list.add(income);
				redisUtil.set(income.getRedisKey(),list);
			}
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				incomeMapper.updateById(income);
				paymentInfoMapper.updateBySocialIncomePayment(paymentId);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送收入到EKP错误", e);
		}
		log.info("推送收入到EKP结束");
	}

	/**
	 * @Description: 合同-批量更换负责人
	 * @Author: huyc
	 * @Date: 2022-7-8
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpIncomePaymentT(TIncome income) {
		log.info("推送收入到EKP-线程开始");
		try {
			String sendBack = this.getSendBack(income);
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				paymentInfoMapper.updateBySocialIncomePayment(income.getSourceId());
				incomeMapper.updateById(income);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送收入到EKP错误", e);
		}
		log.info("推送收入到EKP结束");
	}

	/**
	 * @param income
	 * @Description: 判断类型发送
	 * @Author: hgw
	 * @Date: 2022/9/6 15:15
	 * @return: java.lang.String
	 **/
	private String getSendBack(TIncome income) {
		if (CommonConstants.ONE_STRING.equals(income.getFeeType())) {
			EkpIncomeParamManage sendParam = new EkpIncomeParamManage();
			this.copyToEkpManage(income, sendParam);
			R<EkpIncomePushInfoVo> info = ekpDaprUtil.pushManagerInfoToEkp(sendParam);
			if (!Common.isEmpty(info) && Common.isNotNull(info.getData())) {
				return info.getData().getId();
			} else {
				return "管理费推送失败";
			}
		} else  {
			EkpIncomeParamRisk sendParam = new EkpIncomeParamRisk();
			this.copyToEkpRisk(income, sendParam);
			R<EkpIncomePushInfoVo> info = ekpDaprUtil.pushRiskInfoToEkp(sendParam);
			if (!Common.isEmpty(info) && Common.isNotNull(info.getData())) {
				return info.getData().getId();
			} else {
				return "风险金推送失败";
			}
		}
	}

	/**
	 * @param income    收入
	 * @param sendParam 目标格式
	 * @Description: 转化格式，传到EKP
	 * @Author: hgw
	 * @Date: 2022/9/5 16:57
	 * @return: void
	 **/
	private void copyToEkpManage(TIncome income, EkpIncomeParamManage sendParam) {
		// 项目编码
		sendParam.setFd_3adfef5e5b9d34(income.getDeptNo());
		// 项目名称
		sendParam.setFd_3adfef5eb6691c(income.getDeptName());
		// 单号
		sendParam.setFd_3adfef7f5d2b52("");
		// 客户编码
		sendParam.setFd_3adfef80202ab2(income.getUnitNo());
		// 客户名称
		sendParam.setFd_3adfef7fc1c886(income.getUnitName());
		// 类型：单选（人，人次，比例，固定值，总额）
		// feeMode收费方式：1按比例2金额-人数3金额-人次
		if (CommonConstants.ONE_STRING.equals(income.getFeeMode())) {
			sendParam.setFd_3adda3037e3bda("比例");
		} else if (CommonConstants.TWO_STRING.equals(income.getFeeMode())) {
			sendParam.setFd_3adda3037e3bda("人数");
		} else {
			sendParam.setFd_3adda3037e3bda("人次");
		}
		// 产生来源：单选（社保，工资，商险）
		// sourceType1社保2公积金3商险4薪资
		if (CommonConstants.THREE_STRING.equals(income.getSourceType())) {
			sendParam.setFd_3adda320daef5a("商险");
		} else if (CommonConstants.FOUR_STRING.equals(income.getSourceType())) {
			sendParam.setFd_3adda320daef5a("工资");
		} else if (CommonConstants.TWO_STRING.equals(income.getSourceType())) {
			sendParam.setFd_3adda320daef5a("公积金");
		} else {
			sendParam.setFd_3adda320daef5a("社保");
		}
		// 姓名
		sendParam.setFd_3adfef948da848(income.getEmpName());
		// 身份证号
		sendParam.setFd_3adfef94dcdbb4(income.getEmpIdcard());
		// 生成月份
		if (Common.isEmpty(income.getCreateMonth()) || income.getCreateMonth().length() != 6) {
			sendParam.setFd_3ae0c23b2e9a92(SocialConstants.YEAR_1970);
		} else {
			sendParam.setFd_3ae0c23b2e9a92(income.getCreateMonth().substring(0, 4)
					+ CommonConstants.CENTER_SPLIT_LINE_STRING + income.getCreateMonth().substring(4, 6));
		}
		// 结算月份
		if (Common.isEmpty(income.getPayMonth()) || income.getPayMonth().length() != 6) {
			sendParam.setFd_3ae0c23cb3fccc(SocialConstants.YEAR_1970);
		} else {
			sendParam.setFd_3ae0c23cb3fccc(income.getPayMonth().substring(0, 4)
					+ CommonConstants.CENTER_SPLIT_LINE_STRING + income.getPayMonth().substring(4, 6));
		}
		// 管理费、风险金金额
		sendParam.setFd_3adfef963bae28(String.valueOf(income.getMoney()));
		// 应收
		sendParam.setFd_3adfefa3daae72(String.valueOf(income.getMoney()));
		// 结算状态
		sendParam.setFd_3adfefaaa3bbd0("未结算");
		// 收款状态
		sendParam.setFd_3adfefaaef583e("未收");
		// 结算单号
		sendParam.setFd_3aead3c68b1078("");
		// 收款单号
		sendParam.setFd_3aeae58b14691c("");
		// 管理费id
		sendParam.setFd_3b13dae9bd70f8(income.getId());
		// 薪酬申请编号
		sendParam.setFd_3b3bf13759b850(income.getApplyNo()==null?"":income.getApplyNo());
	}

	private void copyToEkpRisk(TIncome income, EkpIncomeParamRisk sendParam) {
		// 项目编码
		sendParam.setFd_3adfef5e5b9d34(income.getDeptNo());
		// 项目名称
		sendParam.setFd_3adfef5eb6691c(income.getDeptName());
		// 单号
		sendParam.setFd_3adfef7f5d2b52("");
		// 客户编码
		sendParam.setFd_3adfef80202ab2(income.getUnitNo());
		// 客户名称
		sendParam.setFd_3adfef7fc1c886(income.getUnitName());
		// 类型：单选（人，人次，比例，固定值，总额）
		// feeMode收费方式：1按比例2金额-人数3金额-人次
		if (CommonConstants.ONE_STRING.equals(income.getFeeMode())) {
			sendParam.setFd_3adda3037e3bda("比例");
		} else if (CommonConstants.TWO_STRING.equals(income.getFeeMode())) {
			sendParam.setFd_3adda3037e3bda("人数");
		} else {
			sendParam.setFd_3adda3037e3bda("人次");
		}
		// 产生来源：单选（社保，工资，商险）
		// sourceType1社保2公积金3商险4薪资
		if (CommonConstants.THREE_STRING.equals(income.getSourceType())) {
			sendParam.setFd_3adda320daef5a("商险");
		} else if (CommonConstants.FOUR_STRING.equals(income.getSourceType())) {
			sendParam.setFd_3adda320daef5a("工资");
		} else if (CommonConstants.TWO_STRING.equals(income.getSourceType())) {
			sendParam.setFd_3adda320daef5a("公积金");
		} else {
			sendParam.setFd_3adda320daef5a("社保");
		}
		// 姓名
		sendParam.setFd_3adfef948da848(income.getEmpName());
		// 身份证号
		sendParam.setFd_3adfef94dcdbb4(income.getEmpIdcard());
		// 生成月份
		if (Common.isEmpty(income.getCreateMonth()) || income.getCreateMonth().length() != 6) {
			sendParam.setFd_3ae0c3032cffc8(SocialConstants.YEAR_1970);
		} else {
			sendParam.setFd_3ae0c3032cffc8(income.getCreateMonth().substring(0, 4)
					+ CommonConstants.CENTER_SPLIT_LINE_STRING + income.getCreateMonth().substring(4, 6));
		}
		// 结算月份
		if (Common.isEmpty(income.getPayMonth()) || income.getPayMonth().length() != 6) {
			sendParam.setFd_3ae0c3044e5958(SocialConstants.YEAR_1970);
		} else {
			sendParam.setFd_3ae0c3044e5958(income.getPayMonth().substring(0, 4)
					+ CommonConstants.CENTER_SPLIT_LINE_STRING + income.getPayMonth().substring(4, 6));
		}
		// 管理费、风险金金额
		sendParam.setFd_3adfef963bae28(String.valueOf(income.getMoney()));
		// 应收
		sendParam.setFd_3adfefa3daae72(String.valueOf(income.getMoney()));
		// 结算状态
		sendParam.setFd_3adfefaaa3bbd0("未结算");
		// 收款状态
		sendParam.setFd_3adfefaaef583e("未收");
		// 结算单号
		sendParam.setFd_3aead7204bb594("");
		// 收款单号
		sendParam.setFd_3aeae59b70fe5a("");
		// 风险金id
		sendParam.setFd_3b13dac4c03022(income.getId());
		// 薪酬申请编号
		sendParam.setFd_3b3bf0e75ef6c4(income.getApplyNo()==null?"":income.getApplyNo());
	}

	/**
	 * @Description: 实缴数据推送
	 * @Author: huyc
	 * @Date: 2022-11-17
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpPaymentSocial(List<TPaymentInfoPushVo> unPushInfo, Map<String, TSettleDomainSelectVo> mapSelectVo) {
		log.info("推送社保实缴费用到EKP-线程开始");
		TSettleDomain settleDomain;
		EkpPushSocialParam socialParam;

		List<EkpPushSocialParam> insertList = new ArrayList<>();
		try {
			for (TPaymentInfoPushVo library : unPushInfo) {
				//获取项目信息
				if (Common.isNotNull(mapSelectVo)) {
					settleDomain = mapSelectVo.get(library.getSettleDomainCode());
				} else {
					settleDomain = null;
				}
				socialParam = new EkpPushSocialParam();
				//员工姓名
				socialParam.setFd_3adfe8c79989d4(library.getEmpName());
				//员工身份证
				socialParam.setFd_3adfe8c7e4cf7a(library.getEmpIdcard());
				//单位养老金额
				socialParam.setFd_3af9ec80a9de7a(CommonConstants.EMPTY_STRING);
				//单位医疗金额
				socialParam.setFd_3af9eba5899c90(CommonConstants.EMPTY_STRING);
				//单位工伤金额
				socialParam.setFd_3af9eba684f592(CommonConstants.EMPTY_STRING);
				//单位失业金额
				socialParam.setFd_3af9eba5f6e19e(CommonConstants.EMPTY_STRING);
				//单位生育金额
				socialParam.setFd_3af9eba71c0138(CommonConstants.EMPTY_STRING);
				//单位大病金额
				socialParam.setFd_3af9eba863c0ee(CommonConstants.EMPTY_STRING);
				//预估个人养老
				socialParam.setFd_3af9ebbd791662(CommonConstants.EMPTY_STRING);
				//预估个人医疗
				socialParam.setFd_3af9ebbdd9797e(CommonConstants.EMPTY_STRING);
				//预估单位合计
				socialParam.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING);
				//个人社保合计
				socialParam.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING);
				//预估个人大病救助
				socialParam.setFd_3af9ebbf3e8be2(CommonConstants.EMPTY_STRING);
				//预估个人失业
				socialParam.setFd_3af9ebbe29ce1c(CommonConstants.EMPTY_STRING);
				//结算状态
				// hgw2022-9-30 12:03:05根据倩倩的需求，改为默认空，未结算
				socialParam.setFd_3add9ea428879a(CommonConstants.SALARY_UNFLAG);
				//社保缴纳月份
				if (Common.isNotNull(library.getSocialPayMonth())) {
					socialParam.setFd_3adfe8cf632700(dateStringInsert(library.getSocialPayMonth()));
				} else {
					socialParam.setFd_3adfe8cf632700(CommonConstants.EMPTY_STRING);
				}
				//社保生成月份
				if (Common.isNotNull(library.getSocialCreateMonth())) {
					socialParam.setFd_3adfe8cb96c41e(library.getSocialCreateMonth());
				} else {
					socialParam.setFd_3adfe8cb96c41e(CommonConstants.EMPTY_STRING);
				}
				//订单类型
				socialParam.setFd_3add9dd7833db8(SocialConstants.DIFF_TYPE_THR);
				//是否有预估
				if (Common.isNotNull(settleDomain) && Common.isNotNull(settleDomain.getSocialType()) &&
						CommonConstants.ONE_STRING.equals(settleDomain.getSocialType())) {
					socialParam.setFd_3add9de0be85e4(CommonConstants.IS_TRUE);
				} else {
					socialParam.setFd_3add9de0be85e4(CommonConstants.IS_FALSE);
				}
				//与工资合并结算
				socialParam.setFd_3add9e1a670144(CommonConstants.IS_FALSE);
				//项目编码
				socialParam.setFd_3adfe8c70d3fd4(library.getSettleDomainCode());
				//项目名称
				socialParam.setFd_3adfe8c8468e54(library.getSettleDomainName());
				//项目编码-原  fxj 20240527 add
				socialParam.setFd_3cfe2da7e35daa(library.getSettleDomainCode());
				//项目名称-原  fxj 20240527 add
				socialParam.setFd_3cfe2db5015d6e(library.getSettleDomainName());
				//单号
				socialParam.setFd_3adfe95c169c48(CommonConstants.EMPTY_STRING);
				//客户编码
				if (Common.isNotNull(settleDomain) && Common.isNotNull(settleDomain.getCustomerNo())) {
					socialParam.setFd_3adfe8c73cb5a4(settleDomain.getCustomerNo());
				} else {
					socialParam.setFd_3adfe8c73cb5a4(CommonConstants.EMPTY_STRING);
				}
				//是否为BPO业务
				socialParam.setFd_3b178dfcf9e3e6(library.getBpoFlag());
				//客户名称
				if (Common.isNotNull(library.getUnitName())) {
					socialParam.setFd_3adfe8c81a0e42(library.getUnitName());
				} else {
					socialParam.setFd_3adfe8c81a0e42(CommonConstants.EMPTY_STRING);
				}
				//社保户
				if (Common.isNotNull(library.getSocialHousehold())) {
					socialParam.setFd_3aeafa25916e82(library.getSocialHousehold());
				} else {
					socialParam.setFd_3aeafa25916e82(CommonConstants.EMPTY_STRING);
				}
				//结算月份
				socialParam.setFd_3adfe8cff746bc(CommonConstants.EMPTY_STRING);
				//单位差异
				socialParam.setFd_3adfeb53c70f72(CommonConstants.EMPTY_STRING);
				//个人差异
				socialParam.setFd_3adfeb5413fb44(CommonConstants.EMPTY_STRING);
				//应收
				socialParam.setFd_3adfeb7b624f06(CommonConstants.EMPTY_STRING);
				//收款状态
				socialParam.setFd_3add9eaeed2560(CommonConstants.EMPTY_STRING);
				//结算单号
				socialParam.setFd_3adfeb830523b6(CommonConstants.EMPTY_STRING);
				//收款单号
				socialParam.setFd_3adfeb8489e6c2(CommonConstants.EMPTY_STRING);
				//应支出
				socialParam.setFd_3adfeb7bd97464(CommonConstants.EMPTY_STRING);
				//支出结算状态
				socialParam.setFd_3add9edfbc6f7e(CommonConstants.EMPTY_STRING);
				//付款状态
				socialParam.setFd_3add9eed23894a(CommonConstants.EMPTY_STRING);
				//支出缴纳单号
				socialParam.setFd_3adfeb83a704c8(CommonConstants.EMPTY_STRING);
				//实缴单位生育
				if (Common.isNotNull(library.getUnitBirthMoney())) {
					socialParam.setFd_3af9ee3afb34c2(library.getUnitBirthMoney().toString());
				} else {
					socialParam.setFd_3af9ee3afb34c2(CommonConstants.EMPTY_STRING);
				}
				//付款单号
				socialParam.setFd_3adfeb84175f28(CommonConstants.EMPTY_STRING);
				//实缴个人合计
				if (Common.isNotNull(library.getSocialSecurityPersonalSum())) {
					socialParam.setFd_3af9ee3cb6d4fa(library.getSocialSecurityPersonalSum().toString());
				} else {
					socialParam.setFd_3af9ee3cb6d4fa(CommonConstants.EMPTY_STRING);
				}
				//预估合计
				socialParam.setFd_3af9ed7e813b86(CommonConstants.EMPTY_STRING);
				//实缴单位合计
				if (Common.isNotNull(library.getUnitSocialSum())) {
					socialParam.setFd_3af9ee3c0bf286(library.getUnitSocialSum().toString());
				} else {
					socialParam.setFd_3af9ee3c0bf286(CommonConstants.EMPTY_STRING);
				}
				//实缴个人补缴利息
				if (Common.isNotNull(library.getPersonalAccrual())) {
					socialParam.setFd_3af9ee3d634946(library.getPersonalAccrual().toString());
				} else {
					socialParam.setFd_3af9ee3d634946(CommonConstants.EMPTY_STRING);
				}
				//实缴单位医疗
				if (Common.isNotNull(library.getUnitMedicalMoney())) {
					socialParam.setFd_3af9ee39dea6a8(library.getUnitMedicalMoney().toString());
				} else {
					socialParam.setFd_3af9ee39dea6a8(CommonConstants.EMPTY_STRING);
				}
				//预估个人补缴利息
				socialParam.setFd_3af9ebbecc4aa8(CommonConstants.EMPTY_STRING);
				//预估单位补缴利息
				socialParam.setFd_3af9eba7c3da5e(CommonConstants.EMPTY_STRING);
				//实缴单位养老
				if (Common.isNotNull(library.getUnitPensionMoney())) {
					socialParam.setFd_3af9ee3938170a(library.getUnitPensionMoney().toString());
				} else {
					socialParam.setFd_3af9ee3938170a(CommonConstants.EMPTY_STRING);
				}
				//实缴个人失业
				if (Common.isNotNull(library.getPersonalUnemploymentMoney())) {
					socialParam.setFd_3af9ee3db44d96(library.getPersonalUnemploymentMoney().toString());
				} else {
					socialParam.setFd_3af9ee3db44d96(CommonConstants.EMPTY_STRING);
				}
				//实缴单位补缴利息
				if (Common.isNotNull(library.getCompanyAccrual())) {
					socialParam.setFd_3af9ee3b5ddae8(library.getCompanyAccrual().toString());
				} else {
					socialParam.setFd_3af9ee3b5ddae8(CommonConstants.EMPTY_STRING);
				}
				//实缴单位大病救助
				if (Common.isNotNull(library.getUnitBigmailmentMoney())) {
					socialParam.setFd_3af9ee3ba76f54(library.getUnitBigmailmentMoney().toString());
				} else {
					socialParam.setFd_3af9ee3ba76f54(CommonConstants.EMPTY_STRING);
				}
				//实缴单位工伤
				if (Common.isNotNull(library.getUnitInjuryMoney())) {
					socialParam.setFd_3af9ee3aa9c84a(library.getUnitInjuryMoney().toString());
				} else {
					socialParam.setFd_3af9ee3aa9c84a(CommonConstants.EMPTY_STRING);
				}
				//实缴合计
				if (Common.isNotNull(library.getSocialSum())) {
					socialParam.setFd_3af9ee3c6bfc74(library.getSocialSum().toString());
				} else {
					socialParam.setFd_3af9ee3c6bfc74(CommonConstants.EMPTY_STRING);
				}
				//实缴个人医疗
				if (Common.isNotNull(library.getPersonalMedicalMoney())) {
					socialParam.setFd_3af9ee3e066d48(library.getPersonalMedicalMoney().toString());
				} else {
					socialParam.setFd_3af9ee3e066d48(CommonConstants.EMPTY_STRING);
				}
				//实缴单位失业
				if (Common.isNotNull(library.getUnitUnemploymentMoney())) {
					socialParam.setFd_3af9ee3a46b7e6(library.getUnitUnemploymentMoney().toString());
				} else {
					socialParam.setFd_3af9ee3a46b7e6(CommonConstants.EMPTY_STRING);
				}
				//实缴个人养老
				if (Common.isNotNull(library.getPersonalPensionMoney())) {
					socialParam.setFd_3af9ee3e513962(library.getPersonalPensionMoney().toString());
				} else {
					socialParam.setFd_3af9ee3e513962(CommonConstants.EMPTY_STRING);
				}
				//实缴个人大病救助
				if (Common.isNotNull(library.getPersonalBigmailmentMoney())) {
					socialParam.setFd_3af9ee3d0ba3b6(library.getPersonalBigmailmentMoney().toString());
				} else {
					socialParam.setFd_3af9ee3d0ba3b6(CommonConstants.EMPTY_STRING);
				}
				//创建人姓名
				if (Common.isNotNull(library.getCreateName())) {
					socialParam.setFd_3b438e33f37378(library.getCreateName());
				} else {
					socialParam.setFd_3b438e33f37378(CommonConstants.EMPTY_STRING);
				}
				// 缴纳地
				if (Common.isNotNull(library.getSocialPayAddr())) {
					socialParam.setFd_3b5cc58d1a70fe(library.getSocialPayAddr());
				} else {
					socialParam.setFd_3b5cc58d1a70fe(CommonConstants.EMPTY_STRING);
				}
				//我司到款单位
				socialParam.setFd_3b01953871b8be(CommonConstants.EMPTY_STRING);
				//社保id
				socialParam.setFd_3b0afbe1f94a08(library.getId());
				// 薪酬申请编号
				socialParam.setFd_3b3cab77923f44(CommonConstants.EMPTY_STRING);
				socialParam.setSocialIds(library.getIds());
				//实缴
				socialParam.setYgFlag(CommonConstants.ZERO_STRING);
				insertList.add(socialParam);
			}
			if (!insertList.isEmpty()) {
				R<EkpSocialPushInfoVo> info = ekpDaprUtil.pushSocialInfoToEkp(insertList);
				if (Common.isNotNull(info) && Common.isNotNull(info.getData())) {
					EkpSocialPushInfoVo vo = info.getData();
					String idList = vo.getPaymentIdSum();
					if (Common.isNotNull(idList)) {
						paymentInfoMapper.updateBySocialPaymentList(idList.substring(0, idList.length() - 1));
					}
					List<TPaymentSocialPush> list = vo.getUnPushInfo();
					if (!list.isEmpty()) {
						socialPushService.saveBatch(list);
					}
				} else {
					TSendEkpError error = new TSendEkpError();
					error.setCreateTime(new Date());
					error.setCreateDay(DateUtil.getThisDay());
					error.setType(CommonConstants.THREE_STRING);
					error.setCreateUserName("社保实缴费用推送");
					error.setLinkId(unPushInfo.get(0).getId());
					error.setTitle("社保明细批量保存失败");
					error.setNums(CommonConstants.ONE_INT);
					tSendEkpErrorService.save(error);
				}
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.THREE_STRING);
			error.setCreateUserName("社保实缴费用推送");
			error.setLinkId(unPushInfo.get(0).getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送社保实缴费用到EKP错误", e);
		}
		log.info("推送社保实缴费用到EKP结束");
	}

	/**
	 * @Description: 实缴数据推送
	 * @Author: huyc
	 * @Date: 2022-11-17
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpPaymentFund(List<TPaymentInfo> unPushInfo, Map<String, TSettleDomainSelectVo> mapSelectVo) {
		log.info("推送公积金实缴费用到EKP-线程开始");
		TSettleDomain settleDomain;
		EkpPushFundParam fundParam;
		List<EkpPushFundParam> paramList = new ArrayList<>();
		try {
			for (TPaymentInfo library : unPushInfo) {
				//获取项目信息
				if (Common.isNotNull(mapSelectVo)) {
					settleDomain = mapSelectVo.get(library.getSettleDomainCode());
				} else {
					settleDomain = null;
				}
				fundParam = new EkpPushFundParam();
				//员工姓名
				fundParam.setFd_3adfe8c79989d4(library.getEmpName());
				//员工身份证
				fundParam.setFd_3adfe8c7e4cf7a(library.getEmpIdcard());
				//预估单位代缴
				fundParam.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING);
				//预估个人代缴
				fundParam.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING);
				//缴纳月份
				if (Common.isNotNull(library.getProvidentPayMonth())) {
					fundParam.setFd_3adfe8cf632700(dateStringInsert(library.getProvidentPayMonth()));
				} else {
					fundParam.setFd_3adfe8cf632700(CommonConstants.EMPTY_STRING);
				}
				//生成月份
				if (Common.isNotNull(library.getProvidentCreateMonth())) {
					fundParam.setFd_3adfe8cb96c41e(library.getProvidentCreateMonth());
				} else {
					fundParam.setFd_3adfe8cb96c41e(CommonConstants.EMPTY_STRING);
				}
				//结算状态
				// hgw2022-9-30 12:03:48根绝倩倩需求变更
				fundParam.setFd_3add9ea428879a(CommonConstants.SALARY_UNFLAG);
				//订单类型
				fundParam.setFd_3add9dd7833db8(SocialConstants.DIFF_TYPE_THR);
				//是否有预估
				if (Common.isNotNull(settleDomain) && Common.isNotNull(settleDomain.getFundType()) &&
						CommonConstants.ONE_STRING.equals(settleDomain.getFundType())) {
					fundParam.setFd_3add9de0be85e4(CommonConstants.IS_TRUE);
				} else {
					fundParam.setFd_3add9de0be85e4(CommonConstants.IS_FALSE);
				}
				//与工资合并结算
				fundParam.setFd_3add9e1a670144(CommonConstants.IS_FALSE);
				//项目编码
				fundParam.setFd_3adfe8c70d3fd4(library.getSettleDomainCode());
				//项目名称
				fundParam.setFd_3adfe8c8468e54(library.getSettleDomainName());
				//单号
				fundParam.setFd_3adfe95c169c48(CommonConstants.EMPTY_STRING);
				//客户编码
				if (Common.isNotNull(settleDomain) && Common.isNotNull(settleDomain.getCustomerNo())) {
					fundParam.setFd_3adfe8c73cb5a4(settleDomain.getCustomerNo());
				} else {
					fundParam.setFd_3adfe8c73cb5a4(CommonConstants.EMPTY_STRING);
				}
				//是否为BPO业务
				fundParam.setFd_3b178ea361cabe(library.getBpoFlag());
				//单位代缴
				if (Common.isNotNull(library.getUnitProvidentSum())) {
					fundParam.setFd_3adfeb52fbe966(library.getUnitProvidentSum().toString());
				} else {
					fundParam.setFd_3adfeb52fbe966(CommonConstants.EMPTY_STRING);
				}
				//个人代缴
				if (Common.isNotNull(library.getPersonalProvidentSum())) {
					fundParam.setFd_3adfeb5366dd82(library.getPersonalProvidentSum().toString());
				} else {
					fundParam.setFd_3adfeb5366dd82(CommonConstants.EMPTY_STRING);
				}
				//客户名称
				fundParam.setFd_3adfe8c81a0e42(library.getUnitName());
				//公积金账户
				if (Common.isNotNull(library.getProvidentHousehold())) {
					fundParam.setFd_3aeafa8cc144bc(library.getProvidentHousehold());
				} else {
					fundParam.setFd_3aeafa8cc144bc(CommonConstants.EMPTY_STRING);
				}
				//结算月份
				fundParam.setFd_3adfe8cff746bc(CommonConstants.EMPTY_STRING);
				//单位差异
				fundParam.setFd_3adfeb53c70f72(CommonConstants.EMPTY_STRING);
				//个人差异
				fundParam.setFd_3adfeb5413fb44(CommonConstants.EMPTY_STRING);
				//应收
				fundParam.setFd_3adfeb7b624f06(CommonConstants.EMPTY_STRING);
				//收款状态
				fundParam.setFd_3add9eaeed2560(CommonConstants.EMPTY_STRING);
				//结算单号
				fundParam.setFd_3adfeb830523b6(CommonConstants.EMPTY_STRING);
				//收款单号
				fundParam.setFd_3adfeb8489e6c2(CommonConstants.EMPTY_STRING);
				//应支出
				fundParam.setFd_3adfeb7bd97464(CommonConstants.EMPTY_STRING);
				//支出结算状态
				fundParam.setFd_3add9edfbc6f7e(CommonConstants.EMPTY_STRING);
				//付款状态
				fundParam.setFd_3add9eed23894a(CommonConstants.EMPTY_STRING);
				//支出缴纳单号
				fundParam.setFd_3adfeb83a704c8(CommonConstants.EMPTY_STRING);
				//付款单号
				fundParam.setFd_3adfeb84175f28(CommonConstants.EMPTY_STRING);
				//我司到款单位
				fundParam.setFd_3b019a2e9bfdd6(CommonConstants.EMPTY_STRING);
				//公积金id
				fundParam.setFd_3b0afbaf10df2c(library.getId());
				// 薪酬申请编号
				fundParam.setFd_3b3cabde83d1d0(CommonConstants.EMPTY_STRING);
				//创建人姓名
				if (Common.isNotNull(library.getCreateName())) {
					fundParam.setFd_3b43922217c6f8(library.getCreateName());
				} else {
					fundParam.setFd_3b43922217c6f8(CommonConstants.EMPTY_STRING);
				}
				//公积金缴纳地
				if (Common.isNotNull(library.getProvidentPayAddr())) {
					fundParam.setFd_3b5cc487bb46fa(library.getProvidentPayAddr());
				} else {
					fundParam.setFd_3b5cc487bb46fa(CommonConstants.EMPTY_STRING);
				}
				paramList.add(fundParam);
			}
			if (!paramList.isEmpty()) {
				R<EkpSocialPushInfoVo> info = ekpDaprUtil.pushFundInfoToEkp(paramList);
				if (Common.isNotNull(info) && Common.isNotNull(info.getData())) {
					EkpSocialPushInfoVo vo = info.getData();
					if (!Common.isEmpty(vo.getPaymentIds())) {
						paymentInfoMapper.batchUpdateFundPaymentByList(vo.getPaymentIds());
					}
				} else {
					TSendEkpError error = new TSendEkpError();
					error.setCreateTime(new Date());
					error.setCreateDay(DateUtil.getThisDay());
					error.setType(CommonConstants.THREE_STRING);
					error.setCreateUserName("公积金实缴费用推送");
					error.setLinkId(unPushInfo.get(0).getId());
					error.setTitle("公积金批量插入失败");
					error.setNums(CommonConstants.ONE_INT);
					tSendEkpErrorService.save(error);
				}
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.THREE_STRING);
			error.setCreateUserName("公积金实缴费用推送");
			error.setLinkId(unPushInfo.get(0).getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("公积金推送实缴费用到EKP错误", e);
		}
		log.info("公积金推送实缴费用到EKP结束");
	}

	/**
	 * @Description: 预估数据推送
	 * @Author: huyc
	 * @Date: 2022-11-17
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpForecastSocial(List<TForecastLibrary> unPushInfo,
											  Map<String, TSettleDomainSelectVo> selectVoMap) {
		ekpForecastSocial(unPushInfo, selectVoMap);
	}
	public void asynchronousEkpForecastSocialAsso(List<TForecastLibrary> unPushInfo,
												  Map<String, TSettleDomainSelectVo> selectVoMap) {
		ekpForecastSocial(unPushInfo, selectVoMap);
	}

	private void ekpForecastSocial(List<TForecastLibrary> unPushInfo,
								   Map<String, TSettleDomainSelectVo> selectVoMap) {
		log.info("推送社保预估费用到EKP-线程开始");
		TSettleDomain settleDomain;
		EkpPushSocialParam socialParam;

		List<EkpPushSocialParam> insertList = new ArrayList<>();
		try {
			for (TForecastLibrary library : unPushInfo) {
				//获取项目信息
				settleDomain = selectVoMap.get(library.getDeptNo());
				if (Common.isEmpty(settleDomain)) {
					ServiceUtil.runTimeExceptionDiy("获取结算主体异常，请检查传参和档案服务状态！");
				}
				if (CommonConstants.ZERO_STRING.equals(settleDomain.getSocialType())) {
					continue;
				}
				socialParam = new EkpPushSocialParam();
				//员工姓名
				socialParam.setFd_3adfe8c79989d4(library.getEmpName());
				//员工身份证
				socialParam.setFd_3adfe8c7e4cf7a(library.getEmpIdcard());
				//单位养老金额
				if (Common.isNotNull(library.getUnitPensionFee())) {
					socialParam.setFd_3af9ec80a9de7a(library.getUnitPensionFee().toString());
				} else {
					socialParam.setFd_3af9ec80a9de7a(CommonConstants.EMPTY_STRING);
				}
				//单位医疗金额
				if (Common.isNotNull(library.getUnitMedicalFee())) {
					socialParam.setFd_3af9eba5899c90(library.getUnitMedicalFee().toString());
				} else {
					socialParam.setFd_3af9eba5899c90(CommonConstants.EMPTY_STRING);
				}
				//单位工伤金额
				if (Common.isNotNull(library.getUnitWorkInjuryFee())) {
					socialParam.setFd_3af9eba684f592(library.getUnitWorkInjuryFee().toString());
				} else {
					socialParam.setFd_3af9eba684f592(CommonConstants.EMPTY_STRING);
				}
				//单位失业金额
				if (Common.isNotNull(library.getUnitUnemploymentFee())) {
					socialParam.setFd_3af9eba5f6e19e(library.getUnitUnemploymentFee().toString());
				} else {
					socialParam.setFd_3af9eba5f6e19e(CommonConstants.EMPTY_STRING);
				}
				//单位生育金额
				if (Common.isNotNull(library.getUnitBirthFee())) {
					socialParam.setFd_3af9eba71c0138(library.getUnitBirthFee().toString());
				} else {
					socialParam.setFd_3af9eba71c0138(CommonConstants.EMPTY_STRING);
				}
				//单位大病金额
				if (Common.isNotNull(library.getUnitBitailmentFee())) {
					socialParam.setFd_3af9eba863c0ee(library.getUnitBitailmentFee().toString());
				} else {
					socialParam.setFd_3af9eba863c0ee(CommonConstants.EMPTY_STRING);
				}
				//个人养老金额
				if (Common.isNotNull(library.getPersonalPensionFee())) {
					socialParam.setFd_3af9ebbd791662(library.getPersonalPensionFee().toString());
				} else {
					socialParam.setFd_3af9ebbd791662(CommonConstants.EMPTY_STRING);
				}
				//个人医疗金额
				if (Common.isNotNull(library.getPersonalMedicalFee())) {
					socialParam.setFd_3af9ebbdd9797e(library.getPersonalMedicalFee().toString());
				} else {
					socialParam.setFd_3af9ebbdd9797e(CommonConstants.EMPTY_STRING);
				}
				//单位社保合计
				if (Common.isNotNull(library.getUnitSocialSum())) {
					socialParam.setFd_3adfeb4e8064a8(library.getUnitSocialSum().toString());
				} else {
					socialParam.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING);
				}
				//个人社保合计
				if (Common.isNotNull(library.getPersonalSocialSum())) {
					socialParam.setFd_3adfeb52a4d2e2(library.getPersonalSocialSum().toString());
				} else {
					socialParam.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING);
				}
				//预估个人大病救助
				if (Common.isNotNull(library.getPersonalBigailmentFee())) {
					socialParam.setFd_3af9ebbf3e8be2(library.getPersonalBigailmentFee().toString());
				} else {
					socialParam.setFd_3af9ebbf3e8be2(CommonConstants.EMPTY_STRING);
				}
				//预估个人失业
				if (Common.isNotNull(library.getPersonalUnemploymentFee())) {
					socialParam.setFd_3af9ebbe29ce1c(library.getPersonalUnemploymentFee().toString());
				} else {
					socialParam.setFd_3af9ebbe29ce1c(CommonConstants.EMPTY_STRING);
				}
				//结算状态
				if (Common.isNotNull(library.getSalarySocialFlag())) {
					if (CommonConstants.ONE_STRING.equals(library.getSalarySocialFlag())) {
						socialParam.setFd_3add9ea428879a(CommonConstants.SALARY_ISFLAG);
					} else {
						socialParam.setFd_3add9ea428879a(CommonConstants.SALARY_UNFLAG);
					}
				} else {
					socialParam.setFd_3add9ea428879a(CommonConstants.EMPTY_STRING);
				}
				//社保缴纳月份
				if (Common.isNotNull(library.getSocialPayMonth())) {
					socialParam.setFd_3adfe8cf632700(dateStringInsert(library.getSocialPayMonth()));
				} else {
					socialParam.setFd_3adfe8cf632700(CommonConstants.EMPTY_STRING);
				}
				//社保生成月份
				if (Common.isNotNull(library.getSocialCreateMonth())) {
					socialParam.setFd_3adfe8cb96c41e(library.getSocialCreateMonth());
				} else {
					socialParam.setFd_3adfe8cb96c41e(CommonConstants.EMPTY_STRING);
				}
				//订单类型
				socialParam.setFd_3add9dd7833db8(SocialConstants.DIFF_TYPE_ONE);
				//是否有预估
				socialParam.setFd_3add9de0be85e4(CommonConstants.IS_TRUE);
				//与工资合并结算
				socialParam.setFd_3add9e1a670144(CommonConstants.IS_FALSE);
				//项目编码
				socialParam.setFd_3adfe8c70d3fd4(library.getDeptNo());
				//项目名称
				socialParam.setFd_3adfe8c8468e54(library.getDeptName());
				//项目编码-原  fxj 20240527 add
				socialParam.setFd_3cfe2da7e35daa(library.getDeptNo());
				//项目名称-原  fxj 20240527 add
				socialParam.setFd_3cfe2db5015d6e(library.getDeptName());
				//单号
				socialParam.setFd_3adfe95c169c48(CommonConstants.EMPTY_STRING);
				//客户编码
				if (Common.isNotNull(settleDomain.getCustomerNo())) {
					socialParam.setFd_3adfe8c73cb5a4(settleDomain.getCustomerNo());
				} else {
					socialParam.setFd_3adfe8c73cb5a4(CommonConstants.EMPTY_STRING);
				}
				//客户名称
				if (Common.isNotNull(settleDomain.getCustomerName())) {
					socialParam.setFd_3adfe8c81a0e42(settleDomain.getCustomerName());
				} else {
					socialParam.setFd_3adfe8c81a0e42(CommonConstants.EMPTY_STRING);
				}
				//是否为BPO业务
				if (Common.isNotNull(settleDomain.getBpoFlag())) {
					socialParam.setFd_3b178dfcf9e3e6(settleDomain.getBpoFlag());
				} else {
					socialParam.setFd_3b178dfcf9e3e6(CommonConstants.EMPTY_STRING);
				}
				//社保户
				if (Common.isNotNull(library.getSocialHouseholdName())) {
					socialParam.setFd_3aeafa25916e82(library.getSocialHouseholdName());
				} else {
					socialParam.setFd_3aeafa25916e82(CommonConstants.EMPTY_STRING);
				}
				//结算月份
				socialParam.setFd_3adfe8cff746bc(CommonConstants.EMPTY_STRING);
				//单位差异
				socialParam.setFd_3adfeb53c70f72(CommonConstants.EMPTY_STRING);
				//个人差异
				socialParam.setFd_3adfeb5413fb44(CommonConstants.EMPTY_STRING);
				//应收
				socialParam.setFd_3adfeb7b624f06(CommonConstants.EMPTY_STRING);
				//收款状态
				socialParam.setFd_3add9eaeed2560(CommonConstants.EMPTY_STRING);
				//结算单号
				socialParam.setFd_3adfeb830523b6(CommonConstants.EMPTY_STRING);
				//收款单号
				socialParam.setFd_3adfeb8489e6c2(CommonConstants.EMPTY_STRING);
				//应支出
				socialParam.setFd_3adfeb7bd97464(CommonConstants.EMPTY_STRING);
				//支出结算状态
				socialParam.setFd_3add9edfbc6f7e(CommonConstants.EMPTY_STRING);
				//付款状态
				socialParam.setFd_3add9eed23894a(CommonConstants.EMPTY_STRING);
				//支出缴纳单号
				socialParam.setFd_3adfeb83a704c8(CommonConstants.EMPTY_STRING);
				//实缴单位生育
				socialParam.setFd_3af9ee3afb34c2(CommonConstants.EMPTY_STRING);
				//付款单号
				socialParam.setFd_3adfeb84175f28(CommonConstants.EMPTY_STRING);
				//实缴个人合计
				socialParam.setFd_3af9ee3cb6d4fa(CommonConstants.EMPTY_STRING);
				//预估合计
				if (Common.isNotNull(library.getSumAll())) {
					socialParam.setFd_3af9ed7e813b86(library.getSumAll().toString());
				} else {
					socialParam.setFd_3af9ed7e813b86(CommonConstants.EMPTY_STRING);
				}
				//实缴单位合计
				socialParam.setFd_3af9ee3c0bf286(CommonConstants.EMPTY_STRING);
				//实缴个人补缴利息
				socialParam.setFd_3af9ee3d634946(CommonConstants.EMPTY_STRING);
				//实缴单位医疗
				socialParam.setFd_3af9ee39dea6a8(CommonConstants.EMPTY_STRING);
				//预估个人补缴利息
				if (Common.isNotNull(library.getPersonalInterestFee())) {
					socialParam.setFd_3af9ebbecc4aa8(library.getPersonalInterestFee().toString());
				} else {
					socialParam.setFd_3af9ebbecc4aa8(CommonConstants.EMPTY_STRING);
				}
				//预估单位补缴利息
				if (Common.isNotNull(library.getUnitInterestFee())) {
					socialParam.setFd_3af9eba7c3da5e(library.getUnitInterestFee().toString());
				} else {
					socialParam.setFd_3af9eba7c3da5e(CommonConstants.EMPTY_STRING);
				}
				//实缴单位养老
				socialParam.setFd_3af9ee3938170a(CommonConstants.EMPTY_STRING);
				//实缴个人失业
				socialParam.setFd_3af9ee3db44d96(CommonConstants.EMPTY_STRING);
				//实缴单位补缴利息
				socialParam.setFd_3af9ee3b5ddae8(CommonConstants.EMPTY_STRING);
				//实缴单位大病救助
				socialParam.setFd_3af9ee3ba76f54(CommonConstants.EMPTY_STRING);
				//实缴单位工伤
				socialParam.setFd_3af9ee3aa9c84a(CommonConstants.EMPTY_STRING);
				//实缴合计
				socialParam.setFd_3af9ee3c6bfc74(CommonConstants.EMPTY_STRING);
				//实缴个人医疗
				socialParam.setFd_3af9ee3e066d48(CommonConstants.EMPTY_STRING);
				//实缴单位失业
				socialParam.setFd_3af9ee3a46b7e6(CommonConstants.EMPTY_STRING);
				//实缴个人养老
				socialParam.setFd_3af9ee3e513962(CommonConstants.EMPTY_STRING);
				//实缴个人大病救助
				socialParam.setFd_3af9ee3d0ba3b6(CommonConstants.EMPTY_STRING);
				//我司到款单位
				socialParam.setFd_3b01953871b8be(CommonConstants.EMPTY_STRING);
				//社保id
				socialParam.setFd_3b0afbe1f94a08(library.getId());
				// 薪酬申请编号
				socialParam.setFd_3b3cab77923f44(CommonConstants.EMPTY_STRING);
				//预估
				socialParam.setYgFlag(CommonConstants.ONE_STRING);
				//创建人姓名
				if (Common.isNotNull(library.getCreateName())) {
					socialParam.setFd_3b438e33f37378(library.getCreateName());
				} else {
					socialParam.setFd_3b438e33f37378(CommonConstants.EMPTY_STRING);
				}
				//缴纳地拼接
				StringBuilder adress = new StringBuilder();
				adress.append(null!= library.getSocialProvince() ? RedisUtil.redis.opsForValue().get(CacheConstants.AREA_LABEL + library.getSocialProvince()) : "")
						.append(null!= library.getSocialCity() ? "_" + RedisUtil.redis.opsForValue().get(CacheConstants.AREA_LABEL + library.getSocialCity()) : "")
						.append(null!= library.getSocialTown() ? "_" + RedisUtil.redis.opsForValue().get(CacheConstants.AREA_LABEL + library.getSocialTown()) : "");
				socialParam.setFd_3b5cc58d1a70fe(adress.toString());
				insertList.add(socialParam);
			}
			if (!insertList.isEmpty()) {
				R<EkpSocialPushInfoVo> info = ekpDaprUtil.pushSocialInfoToEkp(insertList);
				if (Common.isNotNull(info) && Common.isNotNull(info.getData())) {
					EkpSocialPushInfoVo vo = info.getData();
					List<String> idList = vo.getPaymentIds();
					forecastLibraryMapper.updatePushStatus(idList);
				} else {
					TSendEkpError error = new TSendEkpError();
					error.setCreateTime(new Date());
					error.setCreateDay(DateUtil.getThisDay());
					error.setType(CommonConstants.TWO_STRING);
					error.setCreateUserName("社保预估费用推送");
					error.setLinkId(unPushInfo.get(0).getId());
					error.setTitle("社保预估明细批量保存失败");
					error.setNums(CommonConstants.ONE_INT);
					tSendEkpErrorService.save(error);
				}
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.TWO_STRING);
			error.setCreateUserName("社保预估费用推送");
			error.setLinkId(unPushInfo.get(0).getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送社保预估费用到EKP错误", e);
		}
		log.info("推送社保预估费预估用到EKP结束");
	}

	/**
	 * @Description: 预估数据推送
	 * @Author: huyc
	 * @Date: 2022-11-17
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpForecastFund(List<TForecastLibrary> unPushInfo,
											Map<String, TSettleDomainSelectVo> selectVoMap) {
		initEkpForecastFund(unPushInfo, selectVoMap);
	}

	private void initEkpForecastFund(List<TForecastLibrary> unPushInfo,
									 Map<String, TSettleDomainSelectVo> selectVoMap) {
		log.info("推送公积金预估费用到EKP-线程开始");
		TSettleDomain settleDomain;
		EkpPushFundParam fundParam;
		List<EkpPushFundParam> insertList = new ArrayList<>();
		try {
			for (TForecastLibrary library : unPushInfo) {
				//获取项目信息
				settleDomain = selectVoMap.get(library.getDeptNo());
				if (Common.isEmpty(settleDomain)) {
					ServiceUtil.runTimeExceptionDiy("获取结算主体异常，请检查传参和档案服务状态！");
				}
				if (CommonConstants.ZERO_STRING.equals(settleDomain.getFundType())) {
					continue;
				}
				fundParam = new EkpPushFundParam();
				//员工姓名
				fundParam.setFd_3adfe8c79989d4(library.getEmpName());
				//员工身份证
				fundParam.setFd_3adfe8c7e4cf7a(library.getEmpIdcard());
				//预估单位代缴
				if (Common.isNotNull(library.getUnitFundSum())) {
					fundParam.setFd_3adfeb4e8064a8(library.getUnitFundSum().toString());
				} else {
					fundParam.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING);
				}
				//预估个人代缴
				if (Common.isNotNull(library.getPersonalFundSum())) {
					fundParam.setFd_3adfeb52a4d2e2(library.getPersonalFundSum().toString());
				} else {
					fundParam.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING);
				}
				//缴纳月份
				if (Common.isNotNull(library.getProvidentPayMonth())) {
					fundParam.setFd_3adfe8cf632700(dateStringInsert(library.getProvidentPayMonth()));
				} else {
					fundParam.setFd_3adfe8cf632700(CommonConstants.EMPTY_STRING);
				}
				//生成月份
				if (Common.isNotNull(library.getProvidentCreateMonth())) {
					fundParam.setFd_3adfe8cb96c41e(library.getProvidentCreateMonth());
				} else {
					fundParam.setFd_3adfe8cb96c41e(CommonConstants.EMPTY_STRING);
				}
				//结算状态
				if (Common.isNotNull(library.getSalaryFundFlag())) {
					if (CommonConstants.ONE_STRING.equals(library.getSalaryFundFlag())) {
						fundParam.setFd_3add9ea428879a(CommonConstants.SALARY_ISFLAG);
					} else {
						fundParam.setFd_3add9ea428879a(CommonConstants.SALARY_UNFLAG);
					}
				} else {
					fundParam.setFd_3add9ea428879a(CommonConstants.EMPTY_STRING);
				}
				//订单类型
				fundParam.setFd_3add9dd7833db8(SocialConstants.DIFF_TYPE_ONE);
				//是否有预估
				fundParam.setFd_3add9de0be85e4(CommonConstants.IS_TRUE);
				//与工资合并结算
				fundParam.setFd_3add9e1a670144(CommonConstants.IS_FALSE);
				//项目编码
				fundParam.setFd_3adfe8c70d3fd4(library.getDeptNo());
				//项目名称
				fundParam.setFd_3adfe8c8468e54(library.getDeptName());
				//单号
				fundParam.setFd_3adfe95c169c48(CommonConstants.EMPTY_STRING);
				//客户编码
				if (Common.isNotNull(settleDomain.getCustomerNo())) {
					fundParam.setFd_3adfe8c73cb5a4(settleDomain.getCustomerNo());
				} else {
					fundParam.setFd_3adfe8c73cb5a4(CommonConstants.EMPTY_STRING);
				}
				//单位代缴
				fundParam.setFd_3adfeb52fbe966(CommonConstants.EMPTY_STRING);
				//个人代缴
				fundParam.setFd_3adfeb5366dd82(CommonConstants.EMPTY_STRING);
				//客户名称
				if (Common.isNotNull(settleDomain.getCustomerName())) {
					fundParam.setFd_3adfe8c81a0e42(settleDomain.getCustomerName());
				} else {
					fundParam.setFd_3adfe8c81a0e42(CommonConstants.EMPTY_STRING);
				}
				//是否为BPO业务
				if (Common.isNotNull(settleDomain.getBpoFlag())) {
					fundParam.setFd_3b178ea361cabe(settleDomain.getBpoFlag());
				} else {
					fundParam.setFd_3b178ea361cabe(CommonConstants.EMPTY_STRING);
				}
				//公积金账户
				if (Common.isNotNull(library.getProvidentHouseholdName())) {
					fundParam.setFd_3aeafa8cc144bc(library.getProvidentHouseholdName());
				} else {
					fundParam.setFd_3aeafa8cc144bc(CommonConstants.EMPTY_STRING);
				}
				//结算月份
				fundParam.setFd_3adfe8cff746bc(CommonConstants.EMPTY_STRING);
				//单位差异
				fundParam.setFd_3adfeb53c70f72(CommonConstants.EMPTY_STRING);
				//个人差异
				fundParam.setFd_3adfeb5413fb44(CommonConstants.EMPTY_STRING);
				//应收
				if (Common.isNotNull(library.getSumAll())) {
					fundParam.setFd_3adfeb7b624f06(library.getSumAll().toString());
				}
				//收款状态
				fundParam.setFd_3add9eaeed2560(CommonConstants.EMPTY_STRING);
				//结算单号
				fundParam.setFd_3adfeb830523b6(CommonConstants.EMPTY_STRING);
				//收款单号
				fundParam.setFd_3adfeb8489e6c2(CommonConstants.EMPTY_STRING);
				//应支出
				fundParam.setFd_3adfeb7bd97464(CommonConstants.EMPTY_STRING);
				//支出结算状态
				fundParam.setFd_3add9edfbc6f7e(CommonConstants.EMPTY_STRING);
				//付款状态
				fundParam.setFd_3add9eed23894a(CommonConstants.EMPTY_STRING);
				//支出缴纳单号
				fundParam.setFd_3adfeb83a704c8(CommonConstants.EMPTY_STRING);
				//付款单号
				fundParam.setFd_3adfeb84175f28(CommonConstants.EMPTY_STRING);
				//我司到款单位
				fundParam.setFd_3b019a2e9bfdd6(CommonConstants.EMPTY_STRING);
				//公积金id
				fundParam.setFd_3b0afbaf10df2c(library.getId());
				// 薪酬申请编号
				fundParam.setFd_3b3cabde83d1d0(CommonConstants.EMPTY_STRING);
				//创建人姓名
				if (Common.isNotNull(library.getCreateName())) {
					fundParam.setFd_3b43922217c6f8(library.getCreateName());
				} else {
					fundParam.setFd_3b43922217c6f8(CommonConstants.EMPTY_STRING);
				}
				//缴纳地拼接
				StringBuilder adress = new StringBuilder();
				adress.append(null != library.getFundProvince() ? RedisUtil.redis.opsForValue().get(CacheConstants.AREA_LABEL + library.getFundProvince()) : "")
						.append(null != library.getFundCity() ? "_" + RedisUtil.redis.opsForValue().get(CacheConstants.AREA_LABEL + library.getFundCity()) : "")
						.append(null != library.getFundTown() ? "_" + RedisUtil.redis.opsForValue().get(CacheConstants.AREA_LABEL + library.getFundTown()) : "");
				fundParam.setFd_3b5cc487bb46fa(adress.toString());
				insertList.add(fundParam);
			}
			if (!insertList.isEmpty()) {
				R<EkpSocialPushInfoVo> info = ekpDaprUtil.pushFundInfoToEkp(insertList);
				if (Common.isNotNull(info) && Common.isNotNull(info.getData())) {
					EkpSocialPushInfoVo vo = info.getData();
					List<String> idList = vo.getPaymentIds();
					forecastLibraryMapper.updatePushStatus(idList);
				} else {
					TSendEkpError error = new TSendEkpError();
					error.setCreateTime(new Date());
					error.setCreateDay(DateUtil.getThisDay());
					error.setType(CommonConstants.TWO_STRING);
					error.setCreateUserName("公积金预估费用推送");
					error.setLinkId(unPushInfo.get(0).getId());
					error.setTitle("公积金预估明细批量保存失败");
					error.setNums(CommonConstants.ONE_INT);
					tSendEkpErrorService.save(error);
				}
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.TWO_STRING);
			error.setCreateUserName("公积金预估费用推送");
			error.setLinkId(unPushInfo.get(0).getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送公积金预估费用到EKP错误", e);
		}
		log.info("推送公积金预估费用到EKP结束");
	}

	/**
	 * @Description: 合同-批量更换负责人
	 * @Author: huyc
	 * @Date: 2022-7-8
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpIncomeT(TIncome income) {
		log.info("推送收入到EKP-线程开始");
		try {
			String sendBack = this.getSendBack(income);
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				incomeMapper.updateById(income);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送收入到EKP错误", e);
		}
		log.info("推送收入到EKP结束");
	}

	public void asynchronousEkpIncomeAssoT(TIncome income) {
		log.info("推送收入到EKP-线程开始");
		try {
			String sendBack = this.getSendBack(income);
			income.setSendTime(new Date());
			if (Common.isNotNull(sendBack) && sendBack.length() == 19) {
				income.setSendStatus(CommonConstants.ONE_STRING);
				income.setSendMonth(DateUtil.addMonth(0));
				income.setEkpId(sendBack);
				incomeMapper.updateById(income);
			} else {
				TSendEkpError error = new TSendEkpError();
				error.setCreateTime(new Date());
				error.setCreateDay(DateUtil.getThisDay());
				error.setType(CommonConstants.FOUR_STRING);
				error.setCreateUserName("收入表推送");
				error.setLinkId(income.getId());
				error.setTitle(sendBack);
				error.setNums(CommonConstants.ONE_INT);
				tSendEkpErrorService.save(error);
			}
		} catch (Exception e) {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FOUR_STRING);
			error.setCreateUserName("收入表推送");
			error.setLinkId(income.getId());
			error.setTitle(e.getMessage());
			error.setNums(CommonConstants.ONE_INT);
			tSendEkpErrorService.save(error);
			log.error("推送收入到EKP错误", e);
		}
		log.info("推送收入到EKP结束");
	}

	/**
	 * @Description: 管理费批量推送
	 * @Author: huyc
	 * @Date: 2024-3-19
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpIncomePush(List<TIncome> pushList) {
		List<EkpIncomeParamManage> incomeList = new ArrayList<>();
		for (TIncome income : pushList) {
			EkpIncomeParamManage sendParam = new EkpIncomeParamManage();
			this.copyToEkpManage(income, sendParam);
			incomeList.add(sendParam);
		}
		R<EkpSocialPushInfoVo> info = ekpDaprUtil.jobPushManagerInfoToEkp(incomeList);
		if (!Common.isEmpty(info) && Common.isNotNull(info.getData())) {
			EkpSocialPushInfoVo vo = info.getData();
			List<String> idList = vo.getPaymentIds();
			if (Common.isNotNull(idList)) {
				incomeMapper.updateIncomeByIdList(idList);
			}
		} else {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FIVE_STRING);
			error.setLinkId(pushList.get(0).getId());
			error.setTitle("管理费批量推送失败");
			error.setNums(1);
			tSendEkpErrorService.save(error);
		}
	}

	/**
	 * @Description: 风险金批量推送
	 * @Author: huyc
	 * @Date: 2024-3-19
	 * @return: void
	 **/
	@Async
	public void asynchronousEkpIncomeRiskPush(List<TIncome> pushList) {
		List<EkpIncomeParamRisk> incomeList = new ArrayList<>();
		for (TIncome income : pushList) {
			EkpIncomeParamRisk sendParam = new EkpIncomeParamRisk();
			this.copyToEkpRisk(income, sendParam);
			incomeList.add(sendParam);
		}
		R<EkpSocialPushInfoVo> info = ekpDaprUtil.jobpushRiskInfoToEkp(incomeList);
		if (!Common.isEmpty(info) && Common.isNotNull(info.getData())) {
			EkpSocialPushInfoVo vo = info.getData();
			List<String> idList = vo.getPaymentIds();
			if (Common.isNotNull(idList)) {
				incomeMapper.updateIncomeByIdList(idList);
			}
		} else {
			TSendEkpError error = new TSendEkpError();
			error.setCreateTime(new Date());
			error.setCreateDay(DateUtil.getThisDay());
			error.setType(CommonConstants.FIVE_STRING);
			error.setLinkId(pushList.get(0).getId());
			error.setTitle("风险金批量推送失败");
			error.setNums(1);
			tSendEkpErrorService.save(error);
		}

	}

	public void asynchronousEkpForecastFundAsso(List<TForecastLibrary> unPushInfo,
												Map<String, TSettleDomainSelectVo> selectVoMap) {
		initEkpForecastFund(unPushInfo, selectVoMap);
	}

	/**
	 * @Description: 推送ekp时更改日期格式
	 * @Author: huyc
	 **/
	public String dateStringInsert(String month) {
		StringBuilder sb = new StringBuilder(month);
		sb.insert(4, "-");
		return sb.toString();
	}
}
