/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 预入职-人员档案表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_employee_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-人员档案表")
public class TPreEmployeeInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工主码（系统自动生成：ZM+年月日+5位数字）
	 */
	@ExcelAttribute(name = "员工主码（系统自动生成：ZM+年月日+5位数字）", isNotEmpty = true, errorInfo = "员工主码（系统自动生成：ZM+年月日+5位数字）不能为空", maxLength = 16)
	@NotBlank(message = "员工主码（系统自动生成：ZM+年月日+5位数字）不能为空")
	@Length(max = 16, message = "员工主码（系统自动生成：ZM+年月日+5位数字）不能超过16个字符")
	@ExcelProperty("员工主码（系统自动生成：ZM+年月日+5位数字）")
	@Schema(description = "员工主码（系统自动生成：ZM+年月日+5位数字）")
	private String empCode;
	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@ExcelAttribute(name = "员工类型（字典值，0外包1派遣2代理）", isNotEmpty = true, errorInfo = "员工类型（字典值，0外包1派遣2代理）不能为空", maxLength = 2)
	@NotBlank(message = "员工类型（字典值，0外包1派遣2代理）不能为空")
	@Length(max = 2, message = "员工类型（字典值，0外包1派遣2代理）不能超过2个字符")
	@ExcelProperty("员工类型（字典值，0外包1派遣2代理）")
	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	private String empNatrue;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号码
	 */
	@ExcelAttribute(name = "身份证号码", isNotEmpty = true, errorInfo = "身份证号码不能为空", maxLength = 32)
	@NotBlank(message = "身份证号码不能为空")
	@Length(max = 32, message = "身份证号码不能超过32个字符")
	@ExcelProperty("身份证号码")
	@Schema(description = "身份证号码")
	private String empIdcard;
	/**
	 * 身份证有效期起
	 */
	@ExcelAttribute(name = "身份证有效期起", isDate = true)
	@ExcelProperty("身份证有效期起")
	@Schema(description = "身份证有效期起")
	private Date validityStart;
	/**
	 * 身份证有效期止
	 */
	@ExcelAttribute(name = "身份证有效期止", isDate = true)
	@ExcelProperty("身份证有效期止")
	@Schema(description = "身份证有效期止")
	private Date validityEnd;
	/**
	 * 性别
	 */
	@ExcelAttribute(name = "性别", maxLength = 32)
	@Length(max = 32, message = "性别不能超过32个字符")
	@ExcelProperty("性别")
	@Schema(description = "性别")
	private String empSex;
	/**
	 * 出生日期
	 */
	@ExcelAttribute(name = "出生日期", isDate = true)
	@ExcelProperty("出生日期")
	@Schema(description = "出生日期")
	private java.sql.Date empBirthday;
	/**
	 * 年龄
	 */
	@ExcelAttribute(name = "年龄")
	@ExcelProperty("年龄")
	@Schema(description = "年龄")
	private Integer empAge;
	/**
	 * 婚姻状态
	 */
	@ExcelAttribute(name = "婚姻状态", maxLength = 32)
	@Length(max = 32, message = "婚姻状态不能超过32个字符")
	@ExcelProperty("婚姻状态")
	@Schema(description = "婚姻状态")
	private String empMarriStatus;
	/**
	 * 民族
	 */
	@ExcelAttribute(name = "民族", maxLength = 32)
	@Length(max = 32, message = "民族不能超过32个字符")
	@ExcelProperty("民族")
	@Schema(description = "民族")
	private String empNational;
	/**
	 * 政治面貌
	 */
	@ExcelAttribute(name = "政治面貌", maxLength = 32)
	@Length(max = 32, message = "政治面貌不能超过32个字符")
	@ExcelProperty("政治面貌")
	@Schema(description = "政治面貌")
	private String politicalStatus;
	/**
	 * 邮箱
	 */
	@ExcelAttribute(name = "邮箱", maxLength = 50)
	@Length(max = 50, message = "邮箱不能超过50个字符")
	@ExcelProperty("邮箱")
	@Schema(description = "邮箱")
	private String empEmail;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Length(max = 32, message = "手机号码不能超过32个字符")
	@ExcelProperty("手机号码")
	@Schema(description = "手机号码")
	private String empPhone;
	/**
	 * 身份证-省
	 */
	@ExcelAttribute(name = "身份证-省")
	@ExcelProperty("身份证-省")
	@Schema(description = "身份证-省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idProvince;
	/**
	 * 身份证-市
	 */
	@ExcelAttribute(name = "身份证-市")
	@ExcelProperty("身份证-市")
	@Schema(description = "身份证-市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idCity;
	/**
	 * 身份证-县
	 */
	@ExcelAttribute(name = "身份证-县")
	@ExcelProperty("身份证-县")
	@Schema(description = "身份证-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer idTown;
	/**
	 * 户口性质
	 */
	@ExcelAttribute(name = "户口性质", maxLength = 32)
	@Length(max = 32, message = "户口性质不能超过32个字符")
	@ExcelProperty("户口性质")
	@Schema(description = "户口性质")
	private String empRegisType;
	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省")
	@ExcelProperty("档案-省")
	@Schema(description = "档案-省")
	private Integer fileProvince;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市")
	@ExcelProperty("档案-市")
	@Schema(description = "档案-市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileCity;
	/**
	 * 档案-县
	 */
	@ExcelAttribute(name = "档案-县")
	@ExcelProperty("档案-县")
	@Schema(description = "档案-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Integer fileTown;
	/**
	 * 是否大专及以上（0否1是）
	 */
	@ExcelAttribute(name = "是否大专及以上（0否1是）")
	@ExcelProperty("是否大专及以上（0否1是）")
	@Schema(description = "是否大专及以上（0否1是）")
	private Integer isCollege;
	/**
	 * 最高学历（字典值）
	 */
	@ExcelAttribute(name = "最高学历（字典值）", maxLength = 2)
	@Length(max = 2, message = "最高学历（字典值）不能超过2个字符")
	@ExcelProperty("最高学历（字典值）")
	@Schema(description = "最高学历（字典值）")
	private String hignEducation;
	/**
	 * 学校
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "学校", maxLength = 50)
	@Length(max = 50, message = "学校不能超过50个字符")
	@ExcelProperty("学校")
	@Schema(description = "学校")
	private String school;
	/**
	 * 专业
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "专业", maxLength = 50)
	@Length(max = 50, message = "专业不能超过50个字符")
	@ExcelProperty("专业")
	@Schema(description = "专业")
	private String major;
	/**
	 * 入学时间
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "入学时间", isDate = true)
	@ExcelProperty("入学时间")
	@Schema(description = "入学时间")
	private Date admissionDate;
	/**
	 * 毕业时间
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "毕业时间", isDate = true)
	@ExcelProperty("毕业时间")
	@Schema(description = "毕业时间")
	private Date gradutionDate;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Length(max = 200, message = "备注不能超过200个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;
	/**
	 * 人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入）
	 */
	@ExcelAttribute(name = "人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入）", maxLength = 5)
	@Length(max = 5, message = "人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入）不能超过5个字符")
	@ExcelProperty("人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入）")
	@Schema(description = "人员档案来源（字典：1=社保、公积金派单,2=人员发薪,3=商险派单,4=档案新建,5=批量导入）")
	private String fileSource;
	/**
	 * 人员档案状态（0草稿、1已审核）
	 */
	@ExcelAttribute(name = "人员档案状态（0草稿、1已审核）", isNotEmpty = true, errorInfo = "人员档案状态（0草稿、1已审核）不能为空")
	@NotBlank(message = "人员档案状态（0草稿、1已审核）不能为空")
	@ExcelProperty("人员档案状态（0草稿、1已审核）")
	@Schema(description = "人员档案状态（0草稿、1已审核）")
	private Integer status;
	/**
	 * 档案状态（0正常；1已减档）
	 */
	@ExcelAttribute(name = "档案状态（0正常；1已减档）", isNotEmpty = true, errorInfo = "档案状态（0正常；1已减档）不能为空")
	@NotBlank(message = "档案状态（0正常；1已减档）不能为空")
	@ExcelProperty("档案状态（0正常；1已减档）")
	@Schema(description = "档案状态（0正常；1已减档）")
	private Integer fileStatus;
	/**
	 * 现存项目数
	 */
	@ExcelAttribute(name = "现存项目数")
	@ExcelProperty("现存项目数")
	@Schema(description = "现存项目数")
	private Integer projectNum;
	/**
	 * 员工合同状态（字典:0初始1在用2不在用）
	 */
	@ExcelAttribute(name = "员工合同状态（字典:0初始1在用2不在用）")
	@ExcelProperty("员工合同状态（字典:0初始1在用2不在用）")
	@Schema(description = "员工合同状态（字典:0初始1在用2不在用）")
	private Integer contractStatus;
	/**
	 * 商险状态（字典0无2正常3失效4处理中）
	 */
	@ExcelAttribute(name = "商险状态（字典0无2正常3失效4处理中）")
	@ExcelProperty("商险状态（字典0无2正常3失效4处理中）")
	@Schema(description = "商险状态（字典0无2正常3失效4处理中）")
	private Integer insuranceStatus;
	/**
	 * 社保状态（字典）
	 */
	@ExcelAttribute(name = "社保状态（字典）")
	@ExcelProperty("社保状态（字典）")
	@Schema(description = "社保状态（字典）")
	private Integer socialStatus;
	/**
	 * 公积金状态（字典）
	 */
	@ExcelAttribute(name = "公积金状态（字典）")
	@ExcelProperty("公积金状态（字典）")
	@Schema(description = "公积金状态（字典）")
	private Integer fundStatus;
	/**
	 * 近3个月发薪（0无；1是；2否）
	 */
	@ExcelAttribute(name = "近3个月发薪（0无；1是；2否）")
	@ExcelProperty("近3个月发薪（0无；1是；2否）")
	@Schema(description = "近3个月发薪（0无；1是；2否）")
	private Integer salaryStatus;
	/**
	 * 是否删除 0否/1是
	 */
	@ExcelAttribute(name = "是否删除 0否/1是", isNotEmpty = true, errorInfo = "是否删除 0否/1是不能为空", maxLength = 1)
	@NotBlank(message = "是否删除 0否/1是不能为空")
	@Length(max = 1, message = "是否删除 0否/1是不能超过1个字符")
	@ExcelProperty("是否删除 0否/1是")
	@Schema(description = "是否删除 0否/1是")
	private String deleteFlag;
	/**
	 * 离职操作人id
	 */
	@ExcelAttribute(name = "离职操作人id", maxLength = 32)
	@Length(max = 32, message = "离职操作人id不能超过32个字符")
	@ExcelProperty("离职操作人id")
	@Schema(description = "离职操作人id")
	private String leaveUser;
	/**
	 * 减档人姓名
	 */
	@ExcelAttribute(name = "减档人姓名", maxLength = 32)
	@Length(max = 32, message = "减档人姓名不能超过32个字符")
	@ExcelProperty("减档人姓名")
	@Schema(description = "减档人姓名")
	private String leaveUserName;
	/**
	 * 离职时间
	 */
	@ExcelAttribute(name = "离职时间", isDate = true)
	@ExcelProperty("离职时间")
	@Schema(description = "离职时间")
	private Date leaveTime;
	/**
	 * 离职原因
	 */
	@ExcelAttribute(name = "离职原因", maxLength = 32)
	@Length(max = 32, message = "离职原因不能超过32个字符")
	@ExcelProperty("离职原因")
	@Schema(description = "离职原因")
	private String leaveReason;
	/**
	 * 离职备注
	 */
	@ExcelAttribute(name = "离职备注", maxLength = 255)
	@Length(max = 255, message = "离职备注不能超过255个字符")
	@ExcelProperty("离职备注")
	@Schema(description = "离职备注")
	private String leaveRemark;
	/**
	 * 通信地址
	 */
	@ExcelAttribute(name = "通信地址", maxLength = 200)
	@Length(max = 200, message = "通信地址不能超过200个字符")
	@ExcelProperty("通信地址")
	@Schema(description = "通信地址")
	private String contactAddress;

	/**
	 * 开户行总行
	 */
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Length(max = 50, message = "开户行总行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行总行")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankName;
	/**
	 * 开户行省
	 */
	@ExcelAttribute(name = "开户行省",isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行省")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市",isArea = true,parentField = "bankProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行市")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankCity;
	/**
	 * 开户行支行
	 */
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Length(max = 50, message = "开户行支行不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行支行")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankSubName;
	/**
	 * 银行卡号
	 */
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Length(max = 50, message = "银行卡号不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("银行卡号")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String bankNo;
	/**
	 * 计税月份
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	@Length(max = 6, message = "计税月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计税月份")
	private String taxMonth;

	/**
	 * 计税月份是否可编辑：0否；1是（默认是）
	 */
	@ExcelAttribute(name = "计税月份是否可编辑", maxLength = 1)
	@Length(max = 1, message = "计税月份是否可编辑不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计税月份是否可编辑")
	private String taxMonthFlag;
	/**
	 * 封面抬头
	 */
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;

	/**
	 * 通信地址省
	 */
	@ExcelAttribute(name = "通信地址省",isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址省")
	private String contactProvince;
	/**
	 * 通信地址市
	 */
	@ExcelAttribute(name = "通信地址市",isArea = true,parentField = "contactProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址市")
	private String contactCity;
	/**
	 * 通信地址县
	 */
	@ExcelAttribute(name = "通信地址县",isArea = true,parentField = "contactCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("通信地址县")
	private String contactTown;

	/**
	 * 是否为首份工作 0是/1否
	 */
	@Schema(description ="是否为首份工作 0是/1否")
	private String firstWorkFlag;

	/**
	 * 是否有职业资格证书:0 是  1 否
	 */
	@ExcelAttribute(name = "是否有职业资格证书",isNotEmpty = true,isDataId = true, readConverterExp = "0=是,1=否")
	@Schema(description ="是否有职业资格证书:0 是  1 否")
	private String haveQualification;

}
