package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeRetirement;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeRetirementFlagDetail;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * @author wzb
 * @description TODO
 * @date 2023-05-22 17:44:35
 */
@Data
@ExcelIgnoreUnannotated
public class TEmployeeRetirementExportVo{

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 身份证号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;

	/**
	 * 手机号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	@ExcelAttribute(name = "手机号码")
	@Schema(description = "手机号码")
	private String empPhone;

	/**
	 * 性别
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("性别")
	@ExcelAttribute(name = "性别",readConverterExp = "1=男,2=女")
	@Schema(description = "性别")
	private String empSex;

	/**
	 * 年龄
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年龄(岁)")
	@ExcelAttribute(name = "年龄(岁)")
	@Schema(description = "年龄(岁)")
	private Integer empAge;

	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	@ExcelAttribute(name = "员工类型",readConverterExp = "0=外包,1=派遣,2=代理")
	@Schema(description = "员工类型")
	private String empNatrue;


	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案所在地")
	@ExcelAttribute(name = "档案所在地")
	@Schema(description = "档案所在地")
	private String fileAddress;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地")
	@ExcelAttribute(name = "社保缴纳地")
	@Schema(description = "社保缴纳地")
	private String socialAddress;


	/**
	 * 档案-省
	 */

	@Schema(description = "档案-省")
	private Integer fileProvince;

	/**
	 * 档案-市
	 */
	@JsonIgnore
	@Schema(description = "档案-市")
	private Integer fileCity;

	/**
	 * 档案-县
	 */
	@Schema(description = "档案-县")
	private Integer fileTown;

	/**
	 * 社保-省
	 */
	@Schema(description = "社保-省")
	private Integer socialProvince;

	/**
	 * 社保-市
	 */
	@Schema(description = "社保-市")
	private Integer socialCity;

	/**
	 * 社保-县
	 */
	@Schema(description = "社保-县")
	private Integer socialTown;



	/**
	 * 客户名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	@ExcelAttribute(name = "客户名称")
	@Schema(description = "客户名称")
	private String unitName;

	/**
	 * 客户编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	@ExcelAttribute(name = "客户编码")
	@Schema(description = "客户编码")
	private String unitNo;

	/**
	 * 项目名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 是否处理（0未处理，1处理）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否处理")
	@ExcelAttribute(name = "是否处理")
	@Schema(description = "是否处理")
	private String handleFlag;




}
