package com.yifu.cloud.plus.v1.business.service.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.salary.TSalaryStatisticsDepart;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryCurDepartQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsDepartPageQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsDepartQuery;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsDepartVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * @description: 薪资变动统计表 service层
 * @author: wangweiguo
 * @date: 2021-09-06
*/
public interface TSalaryStatisticsDepartService extends IService<TSalaryStatisticsDepart> {

    /**
     * 分页查询: 部门统计条件分页查询
     * @param query 部门统计查询条件
     * @return: R<IPage<TSalaryStatisticsDepartVO>>
     * @author: wangweiguo
     * @date: 2021-09-06
    */
    R<IPage<TSalaryStatisticsDepartVO>> getListByPage(TSalaryStatisticsDepartPageQuery query);

    /**
     * 列表查询: 部门统计条件查询
     * @param query 部门统计查询条件
     * @return: R<List<TSalaryStatisticsDepartVO>>
     * @author: wangweiguo
     * @date: 2021-09-06
     */
    R<List<TSalaryStatisticsDepartVO>> getList(TSalaryStatisticsDepartQuery query);

    /**
     * 查询: 根据部门id查询当前部门合计
     *
     * @param query 单个部门统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-16
     */
    R<TSalaryTotalVO> getCurDepartSumData(TSalaryCurDepartQuery query);

    /**
     * 查询: 根据部门id查询当前部门统计数据
     *
     * @param query 单个部门统计查询条件
     * @return: R<TSalaryStatisticsDepartVO>
     * @author: wangweiguo
     * @date: 2021-09-16
     */
     R<TSalaryStatisticsDepartVO> getCurDepartData(TSalaryCurDepartQuery query);

    /**
     * 合计: 条件查询部门合计
     * @param query 部门统计查询条件
     * @return: R<TSalaryDepartTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    R<TSalaryTotalVO> getSumDepartByParams(TSalaryStatisticsDepartQuery query);
}
