package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 自有员工所在结算主体大全表
 *
 * @author hgw
 * @date 2021-11-02 17:29:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_own_dept")
@Tag(name = "自有员工所在结算主体大全表")
public class TOwnDept extends Model<TOwnDept> {
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "")
	private Integer id;
	/**
	 * 结算主体id
	 */
	@NotBlank(message = "结算主体id不能为空")
	@Length(max = 32, message = "结算主体id不能超过32个字符")
	@ExcelAttribute(name = "结算主体id", isNotEmpty = true, errorInfo = "结算主体id不能为空", maxLength = 32)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "结算主体id")
	private String deptId;
	/**
	 * 结算主体编码
	 */
	@Length(max = 50, message = "结算主体编码不能超过50个字符")
	@ExcelAttribute(name = "结算主体编码", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "结算主体编码")
	private String deptNo;
	/**
	 * 结算主体名称
	 */
	@Length(max = 50, message = "结算主体名称不能超过50个字符")
	@ExcelAttribute(name = "结算主体名称", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "结算主体名称")
	private String deptName;
	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "客户名称")
	private String unitName;
}
