/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 法大大字段对应信息表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_template_field_info")
@EqualsAndHashCode()
@Schema(description = "法大大字段对应信息表")
public class FddTemplateFieldInfo {

    /**
     * ID
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="ID")
    private String id;

    /**
     * 角色：0个人 1公司
     */
    @Schema(description ="角色：0个人 1公司")
    private String type;

    /**
     * 对应法大大模板字段名称，传给法大大时要初始化
     */
    @Schema(description ="对应法大大模板字段名称，传给法大大时要初始化")
    private String filedName;

    /**
     * 模板ID
     */
    @Schema(description ="模板ID")
    private String templateId;

	/**
	 * 对应法大大模板字段值
	 */
	@Schema(description ="对应法大大模板字段值")
	@TableField(exist = false)
	private String fieldValue;
}
