package com.yifu.cloud.plus.v1.yifu.archives.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpContactInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo;
import com.yifu.cloud.plus.v1.yifu.archives.utils.GZSign;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpInfoPushGzAttaVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpInfoPushGzContractVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpInfoPushGzFileVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpInfoPushGzVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: hgw
 * @Date: 2025-6-23 10:41:07
 * @Description:
 * @return: 瓜子配置
 **/
@Configuration
@Data
@Slf4j
public class GzConfig {

	@Value("${gz.appkey}")
	private String appkey;
	@Value("${gz.appsecret}")
	private String appsecret;
	@Value("${gz.tid}")
	private String tid;
	@Value("${gz.appUrl}")
	private String appUrl;

	private static final String APP_KEY = "appKey";
	private static final String TIMESTAMP = "timestamp";
	private static final String X_REQ_NONCE = "xReqNonce";
	private static final String VERSION = "version";

	public boolean getGzBankInfo(RestTemplate restTemplate, String sortedParams) {
		String gzBankUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/base/bank-branch?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		headers.set("Authorization", "00000000"); // 设置Authorization头
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(null, headers);
		// 发送GET请求
		String result = restTemplate.exchange(gzBankUrl, HttpMethod.GET, entity, String.class).getBody();

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code) && "S00000".equals(code)) {
				JSONArray dataArray = (JSONArray) resultObject.get("data");
				JSONObject dataObject;
				String bankCd;
				String cnapsId;
				for (int i=0;i<dataArray.size(); i++) {
					dataObject = (JSONObject)dataArray.get(i);
				}
				return true;
			}
		}
		return false;
	}

	public Map<String,String> updateGzOfferStatus(RestTemplate restTemplate, Map<String, Object> params) {
		// 签名
		Map<String, Object> authParams = new HashMap<>();
		authParams.put("appsecret", this.getAppsecret());
		authParams.put("tid", this.getTid());
		GZSign.addSignature(authParams, this.getAppkey(), this.getAppsecret());
		String sortedParams = GZSign.getEncodeString(authParams);

		String gzUpdateStatusUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/offer/update-status?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.set("Authorization", "00000000"); // 设置Authorization头
		Gson gson = new Gson();
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(gson.toJson(params), headers);
		Map<String,String> returnMap = new HashMap<>();
		returnMap.put("pushData", gson.toJson(params));

		// 发送POST请求
		String result = restTemplate.exchange(gzUpdateStatusUrl, HttpMethod.POST, entity, String.class).getBody();
		returnMap.put("responseData", result);

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code)) {
				returnMap.put("responseCode", code);
			}
			String message = resultObject.getString("message");
			if (Common.isNotNull(message)) {
				returnMap.put("responseMessage", message);
			}
		}
		return returnMap;
	}

	public Map<String,String> pushGzEmpInfo(RestTemplate restTemplate, TGzEmpInfoPushGzVo a) {
		// 签名
		Map<String, Object> params = new HashMap<>();
		params.put("appsecret", this.getAppsecret());
		params.put("tid", this.getTid());
		GZSign.addSignature(params, this.getAppkey(), this.getAppsecret());
		String sortedParams = GZSign.getEncodeString(params);

		String gzEmpInfoUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/offer/person-info?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.set("Authorization", "00000000"); // 设置Authorization头
		Gson gson = new Gson();
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(gson.toJson(a), headers);
		Map<String,String> returnMap = new HashMap<>();
		returnMap.put("pushData", gson.toJson(a));

		// 发送POST请求
		String result = restTemplate.exchange(gzEmpInfoUrl, HttpMethod.POST, entity, String.class).getBody();
		returnMap.put("responseData", result);

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code)) {
				returnMap.put("responseCode", code);
			}
			String message = resultObject.getString("message");
			if (Common.isNotNull(message)) {
				returnMap.put("responseMessage", message);
			}
		}
		return returnMap;
	}

	public Map<String,String> pushGzEmpContract(RestTemplate restTemplate, TGzEmpInfoPushGzContractVo a) {
		Map<String, Object> authParams = new HashMap<>();
		authParams.put("appsecret", this.getAppsecret());
		authParams.put("tid", this.getTid());
		GZSign.addSignature(authParams, this.getAppkey(), this.getAppsecret());
		String sortedParams = GZSign.getEncodeString(authParams);

		String gzContractUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/offer/person-contract?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.set("Authorization", "00000000"); // 设置Authorization头
		Gson gson = new Gson();
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(gson.toJson(a), headers);
		Map<String,String> returnMap = new HashMap<>();
		returnMap.put("pushData", gson.toJson(a));

		// 发送POST请求
		String result = restTemplate.exchange(gzContractUrl, HttpMethod.POST, entity, String.class).getBody();
		returnMap.put("responseData", result);

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code)) {
				returnMap.put("responseCode", code);
			}
			String message = resultObject.getString("message");
			if (Common.isNotNull(message)) {
				returnMap.put("responseMessage", message);
			}
		}
		return returnMap;
	}

	public boolean pushGzEmpContractFile(RestTemplate restTemplate, TEmpContactInfo a, String sortedParams) {
		String gzBankUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/offer/person-contract?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.set("Authorization", "00000000"); // 设置Authorization头
		Gson gson = new Gson();
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(gson.toJson(a), headers);
		// 发送GET请求
		String result = restTemplate.exchange(gzBankUrl, HttpMethod.POST, entity, String.class).getBody();

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code) && "S00000".equals(code)) {
				return true;
			}
		}
		return false;
	}


	/**
	 * @Description: 4.2.3、员工文件信息上传接口
	 * @Author: hgw
	 * @Date: 2025/7/10 17:44
	 * @return: boolean
	 **/
	public String pushGzFile(RestTemplate restTemplate, TGzEmpInfoPushGzFileVo a) {
		Map<String, Object> authParams = new HashMap<>();
		authParams.put("appsecret", this.getAppsecret());
		authParams.put("tid", this.getTid());
		GZSign.addSignature(authParams, this.getAppkey(), this.getAppsecret());
		String sortedParams = GZSign.getEncodeString(authParams);

		String fileId = null;
		String gzBankUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/file/upload?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.set("Authorization", "00000000"); // 设置Authorization头
		Gson gson = new Gson();
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(gson.toJson(a), headers);
		// 发送GET请求
		String result = restTemplate.exchange(gzBankUrl, HttpMethod.POST, entity, String.class).getBody();


		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code) && "S00000".equals(code)) {
				fileId = resultObject.getString("data");
			}
		}
		return fileId;
	}


	/**
	 * @Description: 4.2.5、员工附件补充接口
	 * @Author: hgw
	 * @Date: 2025/7/10 17:50
	 * @return: boolean
	 **/
	public Map<String,String> pushGzAttach(RestTemplate restTemplate, TGzEmpInfoPushGzAttaVo a) {
		Map<String, Object> authParams = new HashMap<>();
		authParams.put("appsecret", this.getAppsecret());
		authParams.put("tid", this.getTid());
		GZSign.addSignature(authParams, this.getAppkey(), this.getAppsecret());
		String sortedParams = GZSign.getEncodeString(authParams);

		String gzAttachUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/offer/attach?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
		headers.setContentType(type);
		headers.add("Accept", MediaType.APPLICATION_JSON.toString());
		headers.set("Authorization", "00000000"); // 设置Authorization头
		Gson gson = new Gson();
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(gson.toJson(a), headers);
		Map<String,String> returnMap = new HashMap<>();
		returnMap.put("pushData", gson.toJson(a));

		// 发送POST请求
		String result = restTemplate.exchange(gzAttachUrl, HttpMethod.POST, entity, String.class).getBody();

		returnMap.put("responseData", result);

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code)) {
				returnMap.put("responseCode", code);
			}
			String message = resultObject.getString("message");
			if (Common.isNotNull(message)) {
				returnMap.put("responseMessage", message);
			}
		}
		return returnMap;
	}

}
