package com.yifu.cloud.plus.v1.ekp.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author hgw
 * @Date 2024-11-25 10:32:26
 * @Description EKP银企付款获取待查询结果的VO
 * @Version 1.0
 */
@Data
public class EkpBankResultVo implements Serializable {

	private String fdId;
	private String fdParentId;
	private String fdWxNo;
	private String fdSalaryId;

	@Schema(description = "付款银行名称")
	private String fdBankName;
	@Schema(description = "付款银行开户行")
	private String fdBankNo;
	@Schema(description = "付款银行账户")
	private String fdBankAccount;
	@Schema(description = "收款人名称")
	private String fdPayeeName;
	@Schema(description = "收款银行")
	private String fdRecipientBank;

	private Integer fdGrantNum;
	private Integer fdFailNum;
	private Integer num;
}
