package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TOwnDept;
import com.yifu.cloud.plus.v1.yifu.salary.service.TOwnDeptService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * @Author fxj
 * @Description 自有员工所在结算主体大全表
 * @Date 13:32 2022/8/6
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/towndept")
@Tag(name = "自有员工所在结算主体大全表")
public class TOwnDeptController {

	private final TOwnDeptService tOwnDeptService;

	/**
	 * 简单分页查询
	 *
	 * @param page     分页对象
	 * @param tOwnDept 自有员工所在结算主体大全表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TOwnDept>> getTOwnDeptPage(Page<TOwnDept> page, TOwnDept tOwnDept) {
		return new R<>(tOwnDeptService.getTOwnDeptPage(page, tOwnDept));
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "id查询")
	@GetMapping("/{id}")
	public R<TOwnDept> getById(@PathVariable("id") Integer id) {
		return new R<>(tOwnDeptService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tOwnDept
	 * @return R
	 */
	@Operation(description = "新增(wxhr:towndept_add)")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('wxhr:towndept_add')")
	public R<Boolean> save(@Valid @RequestBody TOwnDept tOwnDept) {
		return new R<>(tOwnDeptService.save(tOwnDept));
	}

	/**
	 * 修改记录
	 *
	 * @param tOwnDept
	 * @return R
	 */
	@Operation(description = "修改(wxhr:towndept_edit)")
	@SysLog("修改自有员工所在结算主体大全表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('wxhr:towndept_edit')")
	public R<Boolean> update(@RequestBody TOwnDept tOwnDept) {
		return new R<>(tOwnDeptService.updateById(tOwnDept));
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "删除(wxhr:towndept_del)")
	@SysLog("删除自有员工所在结算主体大全表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('wxhr:towndept_del')")
	public R<Boolean> removeById(@PathVariable Integer id) {
		return new R<>(tOwnDeptService.removeById(id));
	}

}
