package com.yifu.cloud.plus.v1.yifu.social.util;

import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.extern.log4j.Log4j2;
import org.apache.poi.ss.usermodel.*;

import java.util.Random;

/**
 * @Author fxj
 * @Date 2025/9/10
 * @Description 随机签名样式工具类
 * @Version 1.0
 */
@Log4j2
public class RandomFontStyleUtil {
		// 常见中文字体列表
	private static final String[] FONT_NAMES = {
				"小豆岛秋日和简繁-闪","小豆岛风物诗简繁-闪","小豆岛夏情诗简繁-闪", "小豆岛光之愿简-闪 常规", "小豆岛梦之初简-闪 常规",
				"小豆岛春日海简-闪 常规", "小豆岛橄榄树简-闪 常规", "小豆岛闹闹体简-闪",
				"小豆岛夏夕空简繁-闪","小豆岛风物诗简繁-闪"

	};

	// 字体大小范围
	private static final int MIN_FONT_SIZE = 11;
	private static final int MAX_FONT_SIZE = 16;

	/**
	 * 为单元格设置随机字体样式
	 * @param cell Excel单元格
	 * @param value 单元格值
	 */
	public static void setRandomSignatureStyle(Cell cell, String value) {
		if (cell != null && Common.isNotNull(value)) {
			Workbook workbook = cell.getRow().getSheet().getWorkbook();
			Font font = workbook.createFont();

			// 设置随机字体
			Random random = new Random();
			font.setFontName(FONT_NAMES[random.nextInt(FONT_NAMES.length)]);

			// 设置随机字体大小
			font.setFontHeightInPoints((short) (MIN_FONT_SIZE + random.nextInt(MAX_FONT_SIZE - MIN_FONT_SIZE + 1)));

			// 随机设置粗体
			if (random.nextBoolean()) {
				font.setBold(true);
			}

			// 随机设置斜体
			if (random.nextBoolean()) {
				font.setItalic(true);
			}

			// 创建单元格样式并应用字体
			CellStyle cellStyle = workbook.createCellStyle();
			cellStyle.setFont(font);

			//设置单元格边框样式
			cellStyle.setBorderTop(BorderStyle.THIN);
			cellStyle.setBorderBottom(BorderStyle.THIN);
			cellStyle.setBorderLeft(BorderStyle.THIN);
			cellStyle.setBorderRight(BorderStyle.THIN);

			cell.setCellStyle(cellStyle);
			cell.setCellValue(value);
		}
	}


}
