/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 字典项
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
@TableName("sys_auto_dict_item")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "字典项")
public class SysAutoDictItem extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private Long id;
	/**
	 * 字典ID
	 */
	@ExcelAttribute(name = "字典ID")
	@NotBlank(message = "字典ID不能为空")
	@ExcelProperty("字典ID")
	@Schema(description = "字典ID")
	private Long dictId;
	/**
	 * 值
	 */
	@ExcelAttribute(name = "值", maxLength = 100)
	@Length(max = 100, message = "值不能超过100个字符")
	@ExcelProperty("值")
	@Schema(description = "值")
	private String value;
	/**
	 * 标签
	 */
	@ExcelAttribute(name = "标签", maxLength = 100)
	@Length(max = 100, message = "标签不能超过100个字符")
	@ExcelProperty("标签")
	@Schema(description = "标签")
	private String label;
	/**
	 * 字典类型
	 */
	@ExcelAttribute(name = "字典类型", maxLength = 100)
	@Length(max = 100, message = "字典类型不能超过100个字符")
	@ExcelProperty("字典类型")
	@Schema(description = "字典类型")
	private String type;
	/**
	 * 描述
	 */
	@ExcelAttribute(name = "描述", maxLength = 100)
	@Length(max = 100, message = "描述不能超过100个字符")
	@ExcelProperty("描述")
	@Schema(description = "描述")
	private String description;
	/**
	 * 排序（升序）
	 */
	@ExcelAttribute(name = "排序（升序）", isNotEmpty = true, errorInfo = "排序（升序）不能为空")
	@NotBlank(message = "排序（升序）不能为空")
	@ExcelProperty("排序（升序）")
	@Schema(description = "排序（升序）")
	private Integer sortOrder;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Length(max = 255, message = "备注不能超过255个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	private String delFlag;
	/**
	 * 父节点ID
	 */
	@ExcelAttribute(name = "父节点ID")
	@ExcelProperty("父节点ID")
	@Schema(description = "父节点ID")
	private Long parentId;
	/**
	 * 客户端标识
	 */
	@ExcelAttribute(name = "客户端标识", maxLength = 32)
	@Length(max = 32, message = "客户端标识不能超过32个字符")
	@ExcelProperty("客户端标识")
	@Schema(description = "客户端标识")
	private String clientId;
	/**
	 * 是否禁用: 0 启用 1 禁用
	 */
	@ExcelAttribute(name = "是否禁用: 0 启用 1 禁用", isNotEmpty = true, errorInfo = "是否禁用: 0 启用 1 禁用不能为空", maxLength = 1)
	@NotBlank(message = "是否禁用: 0 启用 1 禁用不能为空")
	@Length(max = 1, message = "是否禁用: 0 启用 1 禁用不能超过1个字符")
	@ExcelProperty("是否禁用: 0 启用 1 禁用")
	@Schema(description = "是否禁用: 0 启用 1 禁用")
	private String disable;
	/**
	 * 项目编码，标识此字典项为那个项目所有
	 */
	@ExcelAttribute(name = "项目编码，标识此字典项为那个项目所有", isNotEmpty = true, errorInfo = "项目编码，标识此字典项为那个项目所有不能为空", maxLength = 32)
	@NotBlank(message = "项目编码，标识此字典项为那个项目所有不能为空")
	@Length(max = 32, message = "项目编码，标识此字典项为那个项目所有不能超过32个字符")
	@ExcelProperty("项目编码，标识此字典项为那个项目所有")
	@Schema(description = "项目编码，标识此字典项为那个项目所有")
	private String deptNo;

}
