/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 公积金购买规则主表
 *
 * @author fxj
 * @date 2025-11-06 16:26:08
 */
@Data
@TableName("t_auto_fund_rule_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "公积金购买规则主表")
public class TAutoFundRuleInfo extends BaseEntity {

	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键ID")
	@Schema(description = "主键ID")
	private String id;
	/**
	 * 项目配置ID
	 */
	@ExcelAttribute(name = "项目配置ID", isNotEmpty = true, errorInfo = "项目配置ID不能为空", maxLength = 32)
	@NotBlank(message = "项目配置ID不能为空")
	@Length(max = 32, message = "项目配置ID不能超过32个字符")
	@ExcelProperty("项目配置ID")
	@Schema(description = "项目配置ID")
	private String mainId;
	/**
	 * 是否自动触发派增(字典：0自动触发派增,1：手动派增)
	 */
	@ExcelAttribute(name = "是否自动触发派增", isNotEmpty = true, errorInfo = "是否自动触发派增不能为空", maxLength = 1)
	@NotBlank(message = "是否自动触发派增不能为空")
	@Length(max = 1, message = "是否自动触发派增不能超过1个字符")
	@ExcelProperty("是否自动触发派增")
	@Schema(description = "是否自动触发派增(字典：0自动触发派增,1：手动派增)")
	private String autoFlag;
	/**
	 * 派单发起时间(字典:0：起缴日期当日)
	 */
	@ExcelAttribute(name = "派单发起时间", maxLength = 2)
	@Length(max = 2, message = "派单发起时间不能超过2个字符")
	@ExcelProperty("派单发起时间")
	@Schema(description = "派单发起时间(字典:0：起缴日期当日)")
	private String startPeriod;
	/**
	 * 派单发起具体时间字典：0：15:20
	 */
	@ExcelAttribute(name = "派单发起具体时间字典：0：15:20", maxLength = 10)
	@Length(max = 10, message = "派单发起具体时间字典：0：15:20不能超过10个字符")
	@ExcelProperty("派单发起具体时间字典：0：15:20")
	@Schema(description = "派单发起具体时间字典：0：15:20")
	private String startTime;
	/**
	 * 派单确认时间，字典：0:派单发起当日
	 */
	@ExcelAttribute(name = "派单确认时间", maxLength = 50)
	@Length(max = 50, message = "派单确认时间不能超过50个字符")
	@ExcelProperty("派单确认时间")
	@Schema(description = "派单确认时间，字典：0:派单发起当日")
	private String confirmPeriod;
	/**
	 * 派单确认具体时间：字典0：09:00
	 */
	@ExcelAttribute(name = "派单确认具体时间", maxLength = 10)
	@Length(max = 10, message = "派单确认具体时间不能超过10个字符")
	@ExcelProperty("派单确认具体时间")
	@Schema(description = "派单确认具体时间：0：09:00")
	private String confirmTime;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@ExcelAttribute(name = "项目ID", isNotEmpty = true, errorInfo = "项目ID不能为空", maxLength = 50)
	@NotBlank(message = "项目ID不能为空")
	@Length(max = 50, message = "项目ID不能超过50个字符")
	@ExcelProperty("项目ID")
	@Schema(description = "项目ID")
	private String deptId;


}
